@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Class representing an Event Grid data connection.
 * @property blobStorageEventType The name of blob storage event type to process.
 * @property consumerGroup The event hub consumer group.
 * @property dataFormat The data format of the message. Optionally the data format can be added to each message.
 * @property eventHubResourceId The resource ID where the event grid is configured to send events.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property ignoreFirstRecord A Boolean value that, if set to true, indicates that ingestion should ignore the first record of every file
 * @property kind Kind of the endpoint for the data connection
 * Expected value is 'EventGrid'.
 * @property location Resource location.
 * @property mappingRuleName The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
 * @property name The name of the resource
 * @property provisioningState The provisioned state of the resource.
 * @property storageAccountResourceId The resource ID of the storage account where the data resides.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tableName The table where the data should be ingested. Optionally the table information can be added to each message.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetEventGridDataConnectionResult(
    public val blobStorageEventType: String? = null,
    public val consumerGroup: String,
    public val dataFormat: String? = null,
    public val eventHubResourceId: String,
    public val id: String,
    public val ignoreFirstRecord: Boolean? = null,
    public val kind: String,
    public val location: String? = null,
    public val mappingRuleName: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val storageAccountResourceId: String,
    public val systemData: SystemDataResponse,
    public val tableName: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.GetEventGridDataConnectionResult): GetEventGridDataConnectionResult = GetEventGridDataConnectionResult(
            blobStorageEventType = javaType.blobStorageEventType().map({ args0 -> args0 }).orElse(null),
            consumerGroup = javaType.consumerGroup(),
            dataFormat = javaType.dataFormat().map({ args0 -> args0 }).orElse(null),
            eventHubResourceId = javaType.eventHubResourceId(),
            id = javaType.id(),
            ignoreFirstRecord = javaType.ignoreFirstRecord().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            mappingRuleName = javaType.mappingRuleName().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            storageAccountResourceId = javaType.storageAccountResourceId(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.synapse.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tableName = javaType.tableName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
