@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Class representing an event hub data connection.
 * @property compression The event hub messages compression type
 * @property consumerGroup The event hub consumer group.
 * @property dataFormat The data format of the message. Optionally the data format can be added to each message.
 * @property eventHubResourceId The resource ID of the event hub to be used to create a data connection.
 * @property eventSystemProperties System properties of the event hub
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property kind Kind of the endpoint for the data connection
 * Expected value is 'EventHub'.
 * @property location Resource location.
 * @property managedIdentityResourceId The resource ID of a managed identity (system or user assigned) to be used to authenticate with event hub.
 * @property mappingRuleName The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
 * @property name The name of the resource
 * @property provisioningState The provisioned state of the resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tableName The table where the data should be ingested. Optionally the table information can be added to each message.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetEventHubDataConnectionResult(
    public val compression: String? = null,
    public val consumerGroup: String,
    public val dataFormat: String? = null,
    public val eventHubResourceId: String,
    public val eventSystemProperties: List<String>? = null,
    public val id: String,
    public val kind: String,
    public val location: String? = null,
    public val managedIdentityResourceId: String? = null,
    public val mappingRuleName: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tableName: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.GetEventHubDataConnectionResult): GetEventHubDataConnectionResult = GetEventHubDataConnectionResult(
            compression = javaType.compression().map({ args0 -> args0 }).orElse(null),
            consumerGroup = javaType.consumerGroup(),
            dataFormat = javaType.dataFormat().map({ args0 -> args0 }).orElse(null),
            eventHubResourceId = javaType.eventHubResourceId(),
            eventSystemProperties = javaType.eventSystemProperties().map({ args0 -> args0 }),
            id = javaType.id(),
            kind = javaType.kind(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            managedIdentityResourceId = javaType.managedIdentityResourceId().map({ args0 ->
                args0
            }).orElse(null),
            mappingRuleName = javaType.mappingRuleName().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.synapse.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tableName = javaType.tableName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
