@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * Integration runtime resource type.
 * @property etag Resource Etag.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property properties Integration runtime properties.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetIntegrationRuntimeResult(
    public val etag: String,
    public val id: String,
    public val name: String,
    public val properties: Either<ManagedIntegrationRuntimeResponse, SelfHostedIntegrationRuntimeResponse>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.GetIntegrationRuntimeResult): GetIntegrationRuntimeResult = GetIntegrationRuntimeResult(
            etag = javaType.etag(),
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.synapse.kotlin.outputs.ManagedIntegrationRuntimeResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.synapse.kotlin.outputs.SelfHostedIntegrationRuntimeResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            type = javaType.type(),
        )
    }
}
