@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IP firewall rule
 * @property endIpAddress The end IP address of the firewall rule. Must be IPv4 format. Must be greater than or equal to startIpAddress
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningState Resource provisioning state
 * @property startIpAddress The start IP address of the firewall rule. Must be IPv4 format
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetIpFirewallRuleResult(
    public val endIpAddress: String? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val startIpAddress: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.GetIpFirewallRuleResult): GetIpFirewallRuleResult = GetIpFirewallRuleResult(
            endIpAddress = javaType.endIpAddress().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            startIpAddress = javaType.startIpAddress().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
