@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A SQL Analytics pool
 * @property collation Collation mode
 * @property creationDate Date the SQL pool was created
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property maxSizeBytes Maximum size in bytes
 * @property name The name of the resource
 * @property provisioningState Resource state
 * @property recoverableDatabaseId Backup database to restore from
 * @property restorePointInTime Snapshot time to restore
 * @property sku SQL pool SKU
 * @property sourceDatabaseDeletionDate Specifies the time that the sql pool was deleted
 * @property status Resource status
 * @property storageAccountType The storage account type used to store backups for this sql pool.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetSqlPoolResult(
    public val collation: String? = null,
    public val creationDate: String,
    public val id: String,
    public val location: String,
    public val maxSizeBytes: Double? = null,
    public val name: String,
    public val provisioningState: String? = null,
    public val recoverableDatabaseId: String? = null,
    public val restorePointInTime: String? = null,
    public val sku: SkuResponse? = null,
    public val sourceDatabaseDeletionDate: String? = null,
    public val status: String,
    public val storageAccountType: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.GetSqlPoolResult): GetSqlPoolResult = GetSqlPoolResult(
            collation = javaType.collation().map({ args0 -> args0 }).orElse(null),
            creationDate = javaType.creationDate(),
            id = javaType.id(),
            location = javaType.location(),
            maxSizeBytes = javaType.maxSizeBytes().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            recoverableDatabaseId = javaType.recoverableDatabaseId().map({ args0 -> args0 }).orElse(null),
            restorePointInTime = javaType.restorePointInTime().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sourceDatabaseDeletionDate = javaType.sourceDatabaseDeletionDate().map({ args0 ->
                args0
            }).orElse(null),
            status = javaType.status(),
            storageAccountType = javaType.storageAccountType().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
