@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A sensitivity label.
 * @property columnName The column name.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property informationType The information type.
 * @property informationTypeId The information type ID.
 * @property isDisabled Is sensitivity recommendation disabled. Applicable for recommended sensitivity label only. Specifies whether the sensitivity recommendation on this column is disabled (dismissed) or not.
 * @property labelId The label ID.
 * @property labelName The label name.
 * @property managedBy managed by
 * @property name The name of the resource
 * @property rank
 * @property schemaName The schema name.
 * @property tableName The table name.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetSqlPoolSensitivityLabelResult(
    public val columnName: String,
    public val id: String,
    public val informationType: String? = null,
    public val informationTypeId: String? = null,
    public val isDisabled: Boolean,
    public val labelId: String? = null,
    public val labelName: String? = null,
    public val managedBy: String,
    public val name: String,
    public val rank: String? = null,
    public val schemaName: String,
    public val tableName: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.GetSqlPoolSensitivityLabelResult): GetSqlPoolSensitivityLabelResult = GetSqlPoolSensitivityLabelResult(
            columnName = javaType.columnName(),
            id = javaType.id(),
            informationType = javaType.informationType().map({ args0 -> args0 }).orElse(null),
            informationTypeId = javaType.informationTypeId().map({ args0 -> args0 }).orElse(null),
            isDisabled = javaType.isDisabled(),
            labelId = javaType.labelId().map({ args0 -> args0 }).orElse(null),
            labelName = javaType.labelName().map({ args0 -> args0 }).orElse(null),
            managedBy = javaType.managedBy(),
            name = javaType.name(),
            rank = javaType.rank().map({ args0 -> args0 }).orElse(null),
            schemaName = javaType.schemaName(),
            tableName = javaType.tableName(),
            type = javaType.type(),
        )
    }
}
