@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A Sql pool vulnerability assessment.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property recurringScans The recurring scans settings
 * @property storageContainerPath A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).  It is required if server level vulnerability assessment policy doesn't set
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetSqlPoolVulnerabilityAssessmentResult(
    public val id: String,
    public val name: String,
    public val recurringScans: VulnerabilityAssessmentRecurringScansPropertiesResponse? = null,
    public val storageContainerPath: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.GetSqlPoolVulnerabilityAssessmentResult): GetSqlPoolVulnerabilityAssessmentResult = GetSqlPoolVulnerabilityAssessmentResult(
            id = javaType.id(),
            name = javaType.name(),
            recurringScans = javaType.recurringScans().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.VulnerabilityAssessmentRecurringScansPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageContainerPath = javaType.storageContainerPath().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
