@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A Sql pool vulnerability assessment rule baseline.
 * @property baselineResults The rule baseline result
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetSqlPoolVulnerabilityAssessmentRuleBaselineResult(
    public val baselineResults: List<SqlPoolVulnerabilityAssessmentRuleBaselineItemResponse>,
    public val id: String,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.GetSqlPoolVulnerabilityAssessmentRuleBaselineResult): GetSqlPoolVulnerabilityAssessmentRuleBaselineResult =
            GetSqlPoolVulnerabilityAssessmentRuleBaselineResult(
                baselineResults = javaType.baselineResults().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.synapse.kotlin.outputs.SqlPoolVulnerabilityAssessmentRuleBaselineItemResponse.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                name = javaType.name(),
                type = javaType.type(),
            )
    }
}
