@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Workspace active directory administrator
 * @property administratorType Workspace active directory administrator type
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property login Login of the workspace active directory administrator
 * @property name The name of the resource
 * @property sid Object ID of the workspace active directory administrator
 * @property tenantId Tenant ID of the workspace active directory administrator
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetWorkspaceAadAdminResult(
    public val administratorType: String? = null,
    public val id: String,
    public val login: String? = null,
    public val name: String,
    public val sid: String? = null,
    public val tenantId: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.GetWorkspaceAadAdminResult): GetWorkspaceAadAdminResult = GetWorkspaceAadAdminResult(
            administratorType = javaType.administratorType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            login = javaType.login().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            sid = javaType.sid().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
