@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A workspace
 * @property adlaResourceId The ADLA resource ID.
 * @property connectivityEndpoints Connectivity endpoints
 * @property cspWorkspaceAdminProperties Initial workspace AAD admin properties for a CSP subscription
 * @property defaultDataLakeStorage Workspace default data lake storage account details
 * @property encryption The encryption details of the workspace
 * @property extraProperties Workspace level configs and feature flags
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity Identity of the workspace
 * @property location The geo-location where the resource lives
 * @property managedResourceGroupName Workspace managed resource group. The resource group name uniquely identifies the resource group within the user subscriptionId. The resource group name must be no longer than 90 characters long, and must be alphanumeric characters (Char.IsLetterOrDigit()) and '-', '_', '(', ')' and'.'. Note that the name cannot end with '.'
 * @property managedVirtualNetwork Setting this to 'default' will ensure that all compute for this workspace is in a virtual network managed on behalf of the user.
 * @property managedVirtualNetworkSettings Managed Virtual Network Settings
 * @property name The name of the resource
 * @property privateEndpointConnections Private endpoint connections to the workspace
 * @property provisioningState Resource provisioning state
 * @property publicNetworkAccess Enable or Disable public network access to workspace
 * @property purviewConfiguration Purview Configuration
 * @property settings Workspace settings
 * @property sqlAdministratorLogin Login for workspace SQL active directory administrator
 * @property sqlAdministratorLoginPassword SQL administrator login password
 * @property tags Resource tags.
 * @property trustedServiceBypassEnabled Is trustedServiceBypassEnabled for the workspace
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property virtualNetworkProfile Virtual Network profile
 * @property workspaceRepositoryConfiguration Git integration settings
 * @property workspaceUID The workspace unique identifier
 */
public data class GetWorkspaceResult(
    public val adlaResourceId: String,
    public val connectivityEndpoints: Map<String, String>,
    public val cspWorkspaceAdminProperties: CspWorkspaceAdminPropertiesResponse? = null,
    public val defaultDataLakeStorage: DataLakeStorageAccountDetailsResponse? = null,
    public val encryption: EncryptionDetailsResponse? = null,
    public val extraProperties: Any,
    public val id: String,
    public val identity: ManagedIdentityResponse? = null,
    public val location: String,
    public val managedResourceGroupName: String? = null,
    public val managedVirtualNetwork: String? = null,
    public val managedVirtualNetworkSettings: ManagedVirtualNetworkSettingsResponse? = null,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>? = null,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val purviewConfiguration: PurviewConfigurationResponse? = null,
    public val settings: Map<String, Any>,
    public val sqlAdministratorLogin: String? = null,
    public val sqlAdministratorLoginPassword: String? = null,
    public val tags: Map<String, String>? = null,
    public val trustedServiceBypassEnabled: Boolean? = null,
    public val type: String,
    public val virtualNetworkProfile: VirtualNetworkProfileResponse? = null,
    public val workspaceRepositoryConfiguration: WorkspaceRepositoryConfigurationResponse? = null,
    public val workspaceUID: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.GetWorkspaceResult): GetWorkspaceResult = GetWorkspaceResult(
            adlaResourceId = javaType.adlaResourceId(),
            connectivityEndpoints = javaType.connectivityEndpoints().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            cspWorkspaceAdminProperties = javaType.cspWorkspaceAdminProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.CspWorkspaceAdminPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            defaultDataLakeStorage = javaType.defaultDataLakeStorage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.DataLakeStorageAccountDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.EncryptionDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            extraProperties = javaType.extraProperties(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.ManagedIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            managedResourceGroupName = javaType.managedResourceGroupName().map({ args0 -> args0 }).orElse(null),
            managedVirtualNetwork = javaType.managedVirtualNetwork().map({ args0 -> args0 }).orElse(null),
            managedVirtualNetworkSettings = javaType.managedVirtualNetworkSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.ManagedVirtualNetworkSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            purviewConfiguration = javaType.purviewConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.PurviewConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            settings = javaType.settings().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            sqlAdministratorLogin = javaType.sqlAdministratorLogin().map({ args0 -> args0 }).orElse(null),
            sqlAdministratorLoginPassword = javaType.sqlAdministratorLoginPassword().map({ args0 ->
                args0
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            trustedServiceBypassEnabled = javaType.trustedServiceBypassEnabled().map({ args0 ->
                args0
            }).orElse(null),
            type = javaType.type(),
            virtualNetworkProfile = javaType.virtualNetworkProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.VirtualNetworkProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            workspaceRepositoryConfiguration = javaType.workspaceRepositoryConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.WorkspaceRepositoryConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            workspaceUID = javaType.workspaceUID(),
        )
    }
}
