@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Data flow properties for managed integration runtime.
 * @property computeType Compute type of the cluster which will execute data flow job.
 * @property coreCount Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272.
 * @property timeToLive Time to live (in minutes) setting of the cluster which will execute data flow job.
 */
public data class IntegrationRuntimeDataFlowPropertiesResponse(
    public val computeType: String? = null,
    public val coreCount: Int? = null,
    public val timeToLive: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.IntegrationRuntimeDataFlowPropertiesResponse): IntegrationRuntimeDataFlowPropertiesResponse = IntegrationRuntimeDataFlowPropertiesResponse(
            computeType = javaType.computeType().map({ args0 -> args0 }).orElse(null),
            coreCount = javaType.coreCount().map({ args0 -> args0 }).orElse(null),
            timeToLive = javaType.timeToLive().map({ args0 -> args0 }).orElse(null),
        )
    }
}
