@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Data proxy properties for a managed dedicated integration runtime.
 * @property connectVia The self-hosted integration runtime reference.
 * @property path The path to contain the staged data in the Blob storage.
 * @property stagingLinkedService The staging linked service reference.
 */
public data class IntegrationRuntimeDataProxyPropertiesResponse(
    public val connectVia: EntityReferenceResponse? = null,
    public val path: String? = null,
    public val stagingLinkedService: EntityReferenceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.IntegrationRuntimeDataProxyPropertiesResponse): IntegrationRuntimeDataProxyPropertiesResponse =
            IntegrationRuntimeDataProxyPropertiesResponse(
                connectVia = javaType.connectVia().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.synapse.kotlin.outputs.EntityReferenceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                path = javaType.path().map({ args0 -> args0 }).orElse(null),
                stagingLinkedService = javaType.stagingLinkedService().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.synapse.kotlin.outputs.EntityReferenceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
