@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * SSIS properties for managed integration runtime.
 * @property catalogInfo Catalog information for managed dedicated integration runtime.
 * @property customSetupScriptProperties Custom setup script properties for a managed dedicated integration runtime.
 * @property dataProxyProperties Data proxy properties for a managed dedicated integration runtime.
 * @property edition The edition for the SSIS Integration Runtime
 * @property expressCustomSetupProperties Custom setup without script properties for a SSIS integration runtime.
 * @property licenseType License type for bringing your own license scenario.
 */
public data class IntegrationRuntimeSsisPropertiesResponse(
    public val catalogInfo: IntegrationRuntimeSsisCatalogInfoResponse? = null,
    public val customSetupScriptProperties: IntegrationRuntimeCustomSetupScriptPropertiesResponse? =
        null,
    public val dataProxyProperties: IntegrationRuntimeDataProxyPropertiesResponse? = null,
    public val edition: String? = null,
    public val expressCustomSetupProperties: List<Any>? = null,
    public val licenseType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.IntegrationRuntimeSsisPropertiesResponse): IntegrationRuntimeSsisPropertiesResponse = IntegrationRuntimeSsisPropertiesResponse(
            catalogInfo = javaType.catalogInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.IntegrationRuntimeSsisCatalogInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customSetupScriptProperties = javaType.customSetupScriptProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.IntegrationRuntimeCustomSetupScriptPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataProxyProperties = javaType.dataProxyProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.IntegrationRuntimeDataProxyPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            edition = javaType.edition().map({ args0 -> args0 }).orElse(null),
            expressCustomSetupProperties = javaType.expressCustomSetupProperties().map({ args0 -> args0 }),
            licenseType = javaType.licenseType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
