@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Key encryption key properties
 * @property useSystemAssignedIdentity Boolean specifying whether to use system assigned identity or not
 * @property userAssignedIdentity User assigned identity resource Id
 */
public data class KekIdentityPropertiesResponse(
    public val useSystemAssignedIdentity: Any? = null,
    public val userAssignedIdentity: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.KekIdentityPropertiesResponse): KekIdentityPropertiesResponse = KekIdentityPropertiesResponse(
            useSystemAssignedIdentity = javaType.useSystemAssignedIdentity().map({ args0 ->
                args0
            }).orElse(null),
            userAssignedIdentity = javaType.userAssignedIdentity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
