@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Library/package information of a Big Data pool powered by Apache Spark
 * @property containerName Storage blob container name.
 * @property creatorId Creator Id of the library/package.
 * @property name Name of the library.
 * @property path Storage blob path of library.
 * @property provisioningStatus Provisioning status of the library/package.
 * @property type Type of the library.
 * @property uploadedTimestamp The last update time of the library.
 */
public data class LibraryInfoResponse(
    public val containerName: String? = null,
    public val creatorId: String,
    public val name: String? = null,
    public val path: String? = null,
    public val provisioningStatus: String,
    public val type: String? = null,
    public val uploadedTimestamp: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.LibraryInfoResponse): LibraryInfoResponse = LibraryInfoResponse(
            containerName = javaType.containerName().map({ args0 -> args0 }).orElse(null),
            creatorId = javaType.creatorId(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            provisioningStatus = javaType.provisioningStatus(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            uploadedTimestamp = javaType.uploadedTimestamp(),
        )
    }
}
