@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The key authorization type integration runtime.
 * @property authorizationType The authorization type for integration runtime sharing.
 * Expected value is 'Key'.
 * @property key The key used for authorization.
 */
public data class LinkedIntegrationRuntimeKeyAuthorizationResponse(
    public val authorizationType: String,
    public val key: SecureStringResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.LinkedIntegrationRuntimeKeyAuthorizationResponse): LinkedIntegrationRuntimeKeyAuthorizationResponse =
            LinkedIntegrationRuntimeKeyAuthorizationResponse(
                authorizationType = javaType.authorizationType(),
                key = javaType.key().let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                }),
            )
    }
}
