@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The workspace managed identity
 * @property principalId The principal ID of the workspace managed identity
 * @property tenantId The tenant ID of the workspace managed identity
 * @property type The type of managed identity for the workspace
 * @property userAssignedIdentities The user assigned managed identities.
 */
public data class ManagedIdentityResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String? = null,
    public val userAssignedIdentities: Map<String, UserAssignedManagedIdentityResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.ManagedIdentityResponse): ManagedIdentityResponse = ManagedIdentityResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.synapse.kotlin.outputs.UserAssignedManagedIdentityResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
