@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Managed integration runtime, including managed elastic and managed dedicated integration runtimes.
 * @property computeProperties The compute resource for managed integration runtime.
 * @property customerVirtualNetwork The name of virtual network to which Azure-SSIS integration runtime will join
 * @property description Integration runtime description.
 * @property id The id of the managed virtual network.
 * @property provisioningState Integration runtime state, only valid for managed dedicated integration runtime.
 * @property referenceName The reference name of the managed virtual network
 * @property ssisProperties SSIS properties for managed integration runtime.
 * @property type The type of integration runtime.
 * Expected value is 'Managed'.
 */
public data class ManagedIntegrationRuntimeResponse(
    public val computeProperties: IntegrationRuntimeComputePropertiesResponse? = null,
    public val customerVirtualNetwork: IntegrationRuntimeCustomerVirtualNetworkResponse? = null,
    public val description: String? = null,
    public val id: String? = null,
    public val provisioningState: String,
    public val referenceName: String? = null,
    public val ssisProperties: IntegrationRuntimeSsisPropertiesResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.ManagedIntegrationRuntimeResponse): ManagedIntegrationRuntimeResponse = ManagedIntegrationRuntimeResponse(
            computeProperties = javaType.computeProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.IntegrationRuntimeComputePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customerVirtualNetwork = javaType.customerVirtualNetwork().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.IntegrationRuntimeCustomerVirtualNetworkResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            referenceName = javaType.referenceName().map({ args0 -> args0 }).orElse(null),
            ssisProperties = javaType.ssisProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.IntegrationRuntimeSsisPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
