@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Managed Virtual Network Settings
 * @property allowedAadTenantIdsForLinking Allowed Aad Tenant Ids For Linking
 * @property linkedAccessCheckOnTargetResource Linked Access Check On Target Resource
 * @property preventDataExfiltration Prevent Data Exfiltration
 */
public data class ManagedVirtualNetworkSettingsResponse(
    public val allowedAadTenantIdsForLinking: List<String>? = null,
    public val linkedAccessCheckOnTargetResource: Boolean? = null,
    public val preventDataExfiltration: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.ManagedVirtualNetworkSettingsResponse): ManagedVirtualNetworkSettingsResponse = ManagedVirtualNetworkSettingsResponse(
            allowedAadTenantIdsForLinking = javaType.allowedAadTenantIdsForLinking().map({ args0 -> args0 }),
            linkedAccessCheckOnTargetResource = javaType.linkedAccessCheckOnTargetResource().map({ args0 ->
                args0
            }).orElse(null),
            preventDataExfiltration = javaType.preventDataExfiltration().map({ args0 -> args0 }).orElse(null),
        )
    }
}
