@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Private Endpoint Connection For Private Link Hub - Basic
 * @property id identifier
 * @property privateEndpoint The private endpoint which the connection belongs to.
 * @property privateLinkServiceConnectionState Connection state of the private endpoint connection.
 * @property provisioningState Provisioning state of the private endpoint connection.
 */
public data class PrivateEndpointConnectionForPrivateLinkHubBasicResponse(
    public val id: String,
    public val privateEndpoint: PrivateEndpointResponse? = null,
    public val privateLinkServiceConnectionState: PrivateLinkServiceConnectionStateResponse? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.PrivateEndpointConnectionForPrivateLinkHubBasicResponse): PrivateEndpointConnectionForPrivateLinkHubBasicResponse =
            PrivateEndpointConnectionForPrivateLinkHubBasicResponse(
                id = javaType.id(),
                privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.synapse.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.synapse.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                provisioningState = javaType.provisioningState(),
            )
    }
}
