@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * Self-hosted integration runtime.
 * @property description Integration runtime description.
 * @property linkedInfo Linked integration runtime type from data factory
 * @property type The type of integration runtime.
 * Expected value is 'SelfHosted'.
 */
public data class SelfHostedIntegrationRuntimeResponse(
    public val description: String? = null,
    public val linkedInfo: Either<LinkedIntegrationRuntimeKeyAuthorizationResponse, LinkedIntegrationRuntimeRbacAuthorizationResponse>? =
        null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.SelfHostedIntegrationRuntimeResponse): SelfHostedIntegrationRuntimeResponse = SelfHostedIntegrationRuntimeResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            linkedInfo = javaType.linkedInfo().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.synapse.kotlin.outputs.LinkedIntegrationRuntimeKeyAuthorizationResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.synapse.kotlin.outputs.LinkedIntegrationRuntimeRbacAuthorizationResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
