@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Ssis environment reference.
 * @property environmentFolderName Environment folder name.
 * @property environmentName Environment name.
 * @property id Environment reference id.
 * @property referenceType Reference type
 */
public data class SsisEnvironmentReferenceResponse(
    public val environmentFolderName: String? = null,
    public val environmentName: String? = null,
    public val id: Double? = null,
    public val referenceType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.SsisEnvironmentReferenceResponse): SsisEnvironmentReferenceResponse = SsisEnvironmentReferenceResponse(
            environmentFolderName = javaType.environmentFolderName().map({ args0 -> args0 }).orElse(null),
            environmentName = javaType.environmentName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            referenceType = javaType.referenceType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
