@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Ssis variable.
 * @property dataType Variable type.
 * @property description Variable description.
 * @property id Variable id.
 * @property name Variable name.
 * @property sensitive Whether variable is sensitive.
 * @property sensitiveValue Variable sensitive value.
 * @property value Variable value.
 */
public data class SsisVariableResponse(
    public val dataType: String? = null,
    public val description: String? = null,
    public val id: Double? = null,
    public val name: String? = null,
    public val sensitive: Boolean? = null,
    public val sensitiveValue: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.SsisVariableResponse): SsisVariableResponse = SsisVariableResponse(
            dataType = javaType.dataType().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            sensitive = javaType.sensitive().map({ args0 -> args0 }).orElse(null),
            sensitiveValue = javaType.sensitiveValue().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
