@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of the customer managed key associated with the workspace
 * @property keyVaultUrl Workspace Key sub-resource key vault url
 * @property name Workspace Key sub-resource name
 */
public data class WorkspaceKeyDetailsResponse(
    public val keyVaultUrl: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.WorkspaceKeyDetailsResponse): WorkspaceKeyDetailsResponse = WorkspaceKeyDetailsResponse(
            keyVaultUrl = javaType.keyVaultUrl().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
