@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.syntex.kotlin

import com.pulumi.azurenative.syntex.SyntexFunctions.getDocumentProcessorPlain
import com.pulumi.azurenative.syntex.kotlin.inputs.GetDocumentProcessorPlainArgs
import com.pulumi.azurenative.syntex.kotlin.inputs.GetDocumentProcessorPlainArgsBuilder
import com.pulumi.azurenative.syntex.kotlin.outputs.GetDocumentProcessorResult
import com.pulumi.azurenative.syntex.kotlin.outputs.GetDocumentProcessorResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object SyntexFunctions {
    /**
     * Returns a document processor for a given name.
     * Azure REST API version: 2022-09-15-preview.
     * @param argument null
     * @return Document processor details
     */
    public suspend fun getDocumentProcessor(argument: GetDocumentProcessorPlainArgs): GetDocumentProcessorResult = toKotlin(getDocumentProcessorPlain(argument.toJava()).await())

    /**
     * @see [getDocumentProcessor].
     * @param processorName The name of document processor resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Document processor details
     */
    public suspend fun getDocumentProcessor(processorName: String, resourceGroupName: String): GetDocumentProcessorResult {
        val argument = GetDocumentProcessorPlainArgs(
            processorName = processorName,
            resourceGroupName = resourceGroupName,
        )
        return toKotlin(getDocumentProcessorPlain(argument.toJava()).await())
    }

    /**
     * @see [getDocumentProcessor].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;syntex&#46;kotlin&#46;inputs&#46;GetDocumentProcessorPlainArgs].
     * @return Document processor details
     */
    public suspend fun getDocumentProcessor(argument: suspend GetDocumentProcessorPlainArgsBuilder.() -> Unit): GetDocumentProcessorResult {
        val builder = GetDocumentProcessorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getDocumentProcessorPlain(builtArgument.toJava()).await())
    }
}
