@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.syntex.kotlin.inputs

import com.pulumi.azurenative.syntex.inputs.DocumentProcessorPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Document processor properties
 * @property spoTenantId The ID (GUID) of an SharePoint Online (SPO) tenant associated with this document processor resource
 * @property spoTenantUrl The URL of an SharePoint Online (SPO) tenant associated with this document processor resource
 */
public data class DocumentProcessorPropertiesArgs(
    public val spoTenantId: Output<String>,
    public val spoTenantUrl: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.syntex.inputs.DocumentProcessorPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.syntex.inputs.DocumentProcessorPropertiesArgs =
        com.pulumi.azurenative.syntex.inputs.DocumentProcessorPropertiesArgs.builder()
            .spoTenantId(spoTenantId.applyValue({ args0 -> args0 }))
            .spoTenantUrl(spoTenantUrl.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DocumentProcessorPropertiesArgs].
 */
@PulumiTagMarker
public class DocumentProcessorPropertiesArgsBuilder internal constructor() {
    private var spoTenantId: Output<String>? = null

    private var spoTenantUrl: Output<String>? = null

    /**
     * @param value The ID (GUID) of an SharePoint Online (SPO) tenant associated with this document processor resource
     */
    @JvmName("mmedrrjxlmgwhxux")
    public suspend fun spoTenantId(`value`: Output<String>) {
        this.spoTenantId = value
    }

    /**
     * @param value The URL of an SharePoint Online (SPO) tenant associated with this document processor resource
     */
    @JvmName("mycteuhumwicgwwj")
    public suspend fun spoTenantUrl(`value`: Output<String>) {
        this.spoTenantUrl = value
    }

    /**
     * @param value The ID (GUID) of an SharePoint Online (SPO) tenant associated with this document processor resource
     */
    @JvmName("rkprxfaodsfjxmvi")
    public suspend fun spoTenantId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.spoTenantId = mapped
    }

    /**
     * @param value The URL of an SharePoint Online (SPO) tenant associated with this document processor resource
     */
    @JvmName("nvcrtxnkcjuixcik")
    public suspend fun spoTenantUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.spoTenantUrl = mapped
    }

    internal fun build(): DocumentProcessorPropertiesArgs = DocumentProcessorPropertiesArgs(
        spoTenantId = spoTenantId ?: throw PulumiNullFieldException("spoTenantId"),
        spoTenantUrl = spoTenantUrl ?: throw PulumiNullFieldException("spoTenantUrl"),
    )
}
