@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin

import com.pulumi.azurenative.testbase.CustomImageArgs.builder
import com.pulumi.azurenative.testbase.kotlin.enums.ImageSource
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The test base custom image resource.
 * Azure REST API version: 2023-11-01-preview.
 * ## Example Usage
 * ### CustomImageCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customImage = new AzureNative.TestBase.CustomImage("customImage", new()
 *     {
 *         CustomImageName = "image-2cfb2edc-13bc-4d54-8d6e-38b2a233b003",
 *         DefinitionName = "contoso-image-def",
 *         ResourceGroupName = "contoso-rg1",
 *         Source = AzureNative.TestBase.ImageSource.VHD,
 *         TestBaseAccountName = "contoso-testBaseAccount1",
 *         VersionName = "1.0.0",
 *         VhdId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-rg1/providers/Microsoft.TestBase/testBaseAccounts/contoso-testBaseAccount1/VHDs/vhd-00ac3ccd-1503-4ee5-aa26-26569cfafe88",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/testbase/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := testbase.NewCustomImage(ctx, "customImage", &testbase.CustomImageArgs{
 * 			CustomImageName:     pulumi.String("image-2cfb2edc-13bc-4d54-8d6e-38b2a233b003"),
 * 			DefinitionName:      pulumi.String("contoso-image-def"),
 * 			ResourceGroupName:   pulumi.String("contoso-rg1"),
 * 			Source:              pulumi.String(testbase.ImageSourceVHD),
 * 			TestBaseAccountName: pulumi.String("contoso-testBaseAccount1"),
 * 			VersionName:         pulumi.String("1.0.0"),
 * 			VhdId:               pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-rg1/providers/Microsoft.TestBase/testBaseAccounts/contoso-testBaseAccount1/VHDs/vhd-00ac3ccd-1503-4ee5-aa26-26569cfafe88"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.testbase.CustomImage;
 * import com.pulumi.azurenative.testbase.CustomImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customImage = new CustomImage("customImage", CustomImageArgs.builder()
 *             .customImageName("image-2cfb2edc-13bc-4d54-8d6e-38b2a233b003")
 *             .definitionName("contoso-image-def")
 *             .resourceGroupName("contoso-rg1")
 *             .source("VHD")
 *             .testBaseAccountName("contoso-testBaseAccount1")
 *             .versionName("1.0.0")
 *             .vhdId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-rg1/providers/Microsoft.TestBase/testBaseAccounts/contoso-testBaseAccount1/VHDs/vhd-00ac3ccd-1503-4ee5-aa26-26569cfafe88")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:testbase:CustomImage image-2cfb2edc-13bc-4d54-8d6e-38b2a233b003 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/customImages/{customImageName}
 * ```
 * @property customImageName The resource name of the test base custom image.
 * @property definitionName Image definition name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property source Custom image source type.
 * @property testBaseAccountName The resource name of the Test Base Account.
 * @property versionName Image version name.
 * @property vhdId The Id of the associated VHD resource.
 */
public data class CustomImageArgs(
    public val customImageName: Output<String>? = null,
    public val definitionName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val source: Output<Either<String, ImageSource>>? = null,
    public val testBaseAccountName: Output<String>? = null,
    public val versionName: Output<String>? = null,
    public val vhdId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.CustomImageArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.CustomImageArgs =
        com.pulumi.azurenative.testbase.CustomImageArgs.builder()
            .customImageName(customImageName?.applyValue({ args0 -> args0 }))
            .definitionName(definitionName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .source(
                source?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .testBaseAccountName(testBaseAccountName?.applyValue({ args0 -> args0 }))
            .versionName(versionName?.applyValue({ args0 -> args0 }))
            .vhdId(vhdId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomImageArgs].
 */
@PulumiTagMarker
public class CustomImageArgsBuilder internal constructor() {
    private var customImageName: Output<String>? = null

    private var definitionName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var source: Output<Either<String, ImageSource>>? = null

    private var testBaseAccountName: Output<String>? = null

    private var versionName: Output<String>? = null

    private var vhdId: Output<String>? = null

    /**
     * @param value The resource name of the test base custom image.
     */
    @JvmName("usyjbjcjaxpdjhau")
    public suspend fun customImageName(`value`: Output<String>) {
        this.customImageName = value
    }

    /**
     * @param value Image definition name.
     */
    @JvmName("gycvwkodbxlorcxe")
    public suspend fun definitionName(`value`: Output<String>) {
        this.definitionName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gqixxwfdamtxisjs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Custom image source type.
     */
    @JvmName("klmkifnbbndcyuci")
    public suspend fun source(`value`: Output<Either<String, ImageSource>>) {
        this.source = value
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("rwjlohfwpxwsuyin")
    public suspend fun testBaseAccountName(`value`: Output<String>) {
        this.testBaseAccountName = value
    }

    /**
     * @param value Image version name.
     */
    @JvmName("oetbxofddpqmthwd")
    public suspend fun versionName(`value`: Output<String>) {
        this.versionName = value
    }

    /**
     * @param value The Id of the associated VHD resource.
     */
    @JvmName("oigalsmnlkfbydnm")
    public suspend fun vhdId(`value`: Output<String>) {
        this.vhdId = value
    }

    /**
     * @param value The resource name of the test base custom image.
     */
    @JvmName("rmanmcabamowdqyi")
    public suspend fun customImageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customImageName = mapped
    }

    /**
     * @param value Image definition name.
     */
    @JvmName("dwiqyuamiyjnfpbw")
    public suspend fun definitionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definitionName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vuonxxfjxnlfebab")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Custom image source type.
     */
    @JvmName("fqmoyixpdvaslqrf")
    public suspend fun source(`value`: Either<String, ImageSource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Custom image source type.
     */
    @JvmName("jvvuaunrwmehvjpd")
    public fun source(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ImageSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Custom image source type.
     */
    @JvmName("gqppvmpoaggdlytx")
    public fun source(`value`: ImageSource) {
        val toBeMapped = Either.ofRight<String, ImageSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("mrjcmxmvcnnyypsx")
    public suspend fun testBaseAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testBaseAccountName = mapped
    }

    /**
     * @param value Image version name.
     */
    @JvmName("qkvqdytlbvykxaso")
    public suspend fun versionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionName = mapped
    }

    /**
     * @param value The Id of the associated VHD resource.
     */
    @JvmName("uivxsmohqxcayrga")
    public suspend fun vhdId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vhdId = mapped
    }

    internal fun build(): CustomImageArgs = CustomImageArgs(
        customImageName = customImageName,
        definitionName = definitionName,
        resourceGroupName = resourceGroupName,
        source = source,
        testBaseAccountName = testBaseAccountName,
        versionName = versionName,
        vhdId = vhdId,
    )
}
