@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin

import com.pulumi.azurenative.testbase.DraftPackageArgs.builder
import com.pulumi.azurenative.testbase.kotlin.enums.DraftPackageSourceType
import com.pulumi.azurenative.testbase.kotlin.enums.TestType
import com.pulumi.azurenative.testbase.kotlin.inputs.DraftPackageIntuneAppMetadataArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.DraftPackageIntuneAppMetadataArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.FirstPartyAppDefinitionArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.FirstPartyAppDefinitionArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.GalleryAppDefinitionArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.GalleryAppDefinitionArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.HighlightedFileArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.HighlightedFileArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.InplaceUpgradeOSInfoArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.InplaceUpgradeOSInfoArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.IntuneEnrollmentMetadataArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.IntuneEnrollmentMetadataArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.TabStateArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.TabStateArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.TargetOSInfoArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.TargetOSInfoArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.TestArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.TestArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The Test Base Draft Package resource.
 * Azure REST API version: 2023-11-01-preview.
 * ## Example Usage
 * ### DraftPackageCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var draftPackage = new AzureNative.TestBase.DraftPackage("draftPackage", new()
 *     {
 *         AppFileName = "TestBaseM365DigitalClock.msi",
 *         ApplicationName = "contoso-package",
 *         DraftPackageName = "61d99543-14ff-47ae-bf03-8a8b8445502e",
 *         ResourceGroupName = "contoso-rg1",
 *         SourceType = AzureNative.TestBase.DraftPackageSourceType.Native,
 *         TestBaseAccountName = "contoso-testBaseAccount1",
 *         UseSample = false,
 *         Version = "1.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/testbase/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := testbase.NewDraftPackage(ctx, "draftPackage", &testbase.DraftPackageArgs{
 * 			AppFileName:         pulumi.String("TestBaseM365DigitalClock.msi"),
 * 			ApplicationName:     pulumi.String("contoso-package"),
 * 			DraftPackageName:    pulumi.String("61d99543-14ff-47ae-bf03-8a8b8445502e"),
 * 			ResourceGroupName:   pulumi.String("contoso-rg1"),
 * 			SourceType:          pulumi.String(testbase.DraftPackageSourceTypeNative),
 * 			TestBaseAccountName: pulumi.String("contoso-testBaseAccount1"),
 * 			UseSample:           pulumi.Bool(false),
 * 			Version:             pulumi.String("1.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.testbase.DraftPackage;
 * import com.pulumi.azurenative.testbase.DraftPackageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var draftPackage = new DraftPackage("draftPackage", DraftPackageArgs.builder()
 *             .appFileName("TestBaseM365DigitalClock.msi")
 *             .applicationName("contoso-package")
 *             .draftPackageName("61d99543-14ff-47ae-bf03-8a8b8445502e")
 *             .resourceGroupName("contoso-rg1")
 *             .sourceType("Native")
 *             .testBaseAccountName("contoso-testBaseAccount1")
 *             .useSample(false)
 *             .version("1.0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:testbase:DraftPackage 61d99543-14ff-47ae-bf03-8a8b8445502e /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/draftPackages/{draftPackageName}
 * ```
 * @property appFileName The name of the app file.
 * @property applicationName Application name
 * @property comments Comments added by user.
 * @property draftPackageName The resource name of the Test Base Draft Package.
 * @property editPackage Specifies whether this draft package is used to edit a package.
 * @property executableLaunchCommand The executable launch command for script auto-fill. Will be used to run the application.
 * @property firstPartyApps The list of first party applications to test along with user application.
 * @property flightingRing The flighting ring for feature update.
 * @property galleryApps The list of gallery apps to test along with user application.
 * @property highlightedFiles The highlight files in the package.
 * @property inplaceUpgradeOSPair Specifies the baseline os and target os for inplace upgrade.
 * @property intuneEnrollmentMetadata The metadata of Intune enrollment.
 * @property intuneMetadata Metadata used to generate draft package folder and scripts.
 * @property packageId Specifies the package id from which the draft package copied.
 * @property packageTags Tags of the package to be created.
 * @property processName The process name for script auto-fill. Will be used to identify the application process.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sourceType The source type.
 * @property tabState Tab state.
 * @property targetOSList Specifies the target OSs of specific OS Update types.
 * @property testBaseAccountName The resource name of the Test Base Account.
 * @property testTypes OOB, functional or flow driven. Mapped to the data in 'tests' property.
 * @property tests The detailed test information.
 * @property useAutofill Indicates whether user choose to enable script auto-fill.
 * @property useSample Specifies whether a sample package should be used instead of the one uploaded by the user.
 * @property version Application version
 */
public data class DraftPackageArgs(
    public val appFileName: Output<String>? = null,
    public val applicationName: Output<String>? = null,
    public val comments: Output<String>? = null,
    public val draftPackageName: Output<String>? = null,
    public val editPackage: Output<Boolean>? = null,
    public val executableLaunchCommand: Output<String>? = null,
    public val firstPartyApps: Output<List<FirstPartyAppDefinitionArgs>>? = null,
    public val flightingRing: Output<String>? = null,
    public val galleryApps: Output<List<GalleryAppDefinitionArgs>>? = null,
    public val highlightedFiles: Output<List<HighlightedFileArgs>>? = null,
    public val inplaceUpgradeOSPair: Output<InplaceUpgradeOSInfoArgs>? = null,
    public val intuneEnrollmentMetadata: Output<IntuneEnrollmentMetadataArgs>? = null,
    public val intuneMetadata: Output<DraftPackageIntuneAppMetadataArgs>? = null,
    public val packageId: Output<String>? = null,
    public val packageTags: Output<Map<String, String>>? = null,
    public val processName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sourceType: Output<Either<String, DraftPackageSourceType>>? = null,
    public val tabState: Output<TabStateArgs>? = null,
    public val targetOSList: Output<List<TargetOSInfoArgs>>? = null,
    public val testBaseAccountName: Output<String>? = null,
    public val testTypes: Output<List<Either<String, TestType>>>? = null,
    public val tests: Output<List<TestArgs>>? = null,
    public val useAutofill: Output<Boolean>? = null,
    public val useSample: Output<Boolean>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.DraftPackageArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.DraftPackageArgs =
        com.pulumi.azurenative.testbase.DraftPackageArgs.builder()
            .appFileName(appFileName?.applyValue({ args0 -> args0 }))
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .comments(comments?.applyValue({ args0 -> args0 }))
            .draftPackageName(draftPackageName?.applyValue({ args0 -> args0 }))
            .editPackage(editPackage?.applyValue({ args0 -> args0 }))
            .executableLaunchCommand(executableLaunchCommand?.applyValue({ args0 -> args0 }))
            .firstPartyApps(
                firstPartyApps?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .flightingRing(flightingRing?.applyValue({ args0 -> args0 }))
            .galleryApps(
                galleryApps?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .highlightedFiles(
                highlightedFiles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .inplaceUpgradeOSPair(
                inplaceUpgradeOSPair?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .intuneEnrollmentMetadata(
                intuneEnrollmentMetadata?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .intuneMetadata(intuneMetadata?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .packageId(packageId?.applyValue({ args0 -> args0 }))
            .packageTags(
                packageTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .processName(processName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sourceType(
                sourceType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tabState(tabState?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetOSList(
                targetOSList?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .testBaseAccountName(testBaseAccountName?.applyValue({ args0 -> args0 }))
            .testTypes(
                testTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .tests(tests?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .useAutofill(useAutofill?.applyValue({ args0 -> args0 }))
            .useSample(useSample?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DraftPackageArgs].
 */
@PulumiTagMarker
public class DraftPackageArgsBuilder internal constructor() {
    private var appFileName: Output<String>? = null

    private var applicationName: Output<String>? = null

    private var comments: Output<String>? = null

    private var draftPackageName: Output<String>? = null

    private var editPackage: Output<Boolean>? = null

    private var executableLaunchCommand: Output<String>? = null

    private var firstPartyApps: Output<List<FirstPartyAppDefinitionArgs>>? = null

    private var flightingRing: Output<String>? = null

    private var galleryApps: Output<List<GalleryAppDefinitionArgs>>? = null

    private var highlightedFiles: Output<List<HighlightedFileArgs>>? = null

    private var inplaceUpgradeOSPair: Output<InplaceUpgradeOSInfoArgs>? = null

    private var intuneEnrollmentMetadata: Output<IntuneEnrollmentMetadataArgs>? = null

    private var intuneMetadata: Output<DraftPackageIntuneAppMetadataArgs>? = null

    private var packageId: Output<String>? = null

    private var packageTags: Output<Map<String, String>>? = null

    private var processName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sourceType: Output<Either<String, DraftPackageSourceType>>? = null

    private var tabState: Output<TabStateArgs>? = null

    private var targetOSList: Output<List<TargetOSInfoArgs>>? = null

    private var testBaseAccountName: Output<String>? = null

    private var testTypes: Output<List<Either<String, TestType>>>? = null

    private var tests: Output<List<TestArgs>>? = null

    private var useAutofill: Output<Boolean>? = null

    private var useSample: Output<Boolean>? = null

    private var version: Output<String>? = null

    /**
     * @param value The name of the app file.
     */
    @JvmName("ovemufnsxiamypgf")
    public suspend fun appFileName(`value`: Output<String>) {
        this.appFileName = value
    }

    /**
     * @param value Application name
     */
    @JvmName("mjuybsjknflnufpp")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value Comments added by user.
     */
    @JvmName("wastmpvcsufpyvbf")
    public suspend fun comments(`value`: Output<String>) {
        this.comments = value
    }

    /**
     * @param value The resource name of the Test Base Draft Package.
     */
    @JvmName("trqjpxujejbmgwuf")
    public suspend fun draftPackageName(`value`: Output<String>) {
        this.draftPackageName = value
    }

    /**
     * @param value Specifies whether this draft package is used to edit a package.
     */
    @JvmName("exgjjwreefrqcqds")
    public suspend fun editPackage(`value`: Output<Boolean>) {
        this.editPackage = value
    }

    /**
     * @param value The executable launch command for script auto-fill. Will be used to run the application.
     */
    @JvmName("amuarasdjuxjydwr")
    public suspend fun executableLaunchCommand(`value`: Output<String>) {
        this.executableLaunchCommand = value
    }

    /**
     * @param value The list of first party applications to test along with user application.
     */
    @JvmName("sfksbqsflimtstpq")
    public suspend fun firstPartyApps(`value`: Output<List<FirstPartyAppDefinitionArgs>>) {
        this.firstPartyApps = value
    }

    @JvmName("aaaiwnsfvbnenlox")
    public suspend fun firstPartyApps(vararg values: Output<FirstPartyAppDefinitionArgs>) {
        this.firstPartyApps = Output.all(values.asList())
    }

    /**
     * @param values The list of first party applications to test along with user application.
     */
    @JvmName("qffakdiksjhlodgr")
    public suspend fun firstPartyApps(values: List<Output<FirstPartyAppDefinitionArgs>>) {
        this.firstPartyApps = Output.all(values)
    }

    /**
     * @param value The flighting ring for feature update.
     */
    @JvmName("bxjckxbkwbsafghg")
    public suspend fun flightingRing(`value`: Output<String>) {
        this.flightingRing = value
    }

    /**
     * @param value The list of gallery apps to test along with user application.
     */
    @JvmName("xksceauepmdqyhfa")
    public suspend fun galleryApps(`value`: Output<List<GalleryAppDefinitionArgs>>) {
        this.galleryApps = value
    }

    @JvmName("lhvinwhduqykeynq")
    public suspend fun galleryApps(vararg values: Output<GalleryAppDefinitionArgs>) {
        this.galleryApps = Output.all(values.asList())
    }

    /**
     * @param values The list of gallery apps to test along with user application.
     */
    @JvmName("ttljmxudljurhnfo")
    public suspend fun galleryApps(values: List<Output<GalleryAppDefinitionArgs>>) {
        this.galleryApps = Output.all(values)
    }

    /**
     * @param value The highlight files in the package.
     */
    @JvmName("hhrpqkxxfteknbkl")
    public suspend fun highlightedFiles(`value`: Output<List<HighlightedFileArgs>>) {
        this.highlightedFiles = value
    }

    @JvmName("jvxgfxvectvudlrq")
    public suspend fun highlightedFiles(vararg values: Output<HighlightedFileArgs>) {
        this.highlightedFiles = Output.all(values.asList())
    }

    /**
     * @param values The highlight files in the package.
     */
    @JvmName("cpogxywajxacsona")
    public suspend fun highlightedFiles(values: List<Output<HighlightedFileArgs>>) {
        this.highlightedFiles = Output.all(values)
    }

    /**
     * @param value Specifies the baseline os and target os for inplace upgrade.
     */
    @JvmName("helgdcipftrqraye")
    public suspend fun inplaceUpgradeOSPair(`value`: Output<InplaceUpgradeOSInfoArgs>) {
        this.inplaceUpgradeOSPair = value
    }

    /**
     * @param value The metadata of Intune enrollment.
     */
    @JvmName("ieeqbudbiclyiixp")
    public suspend fun intuneEnrollmentMetadata(`value`: Output<IntuneEnrollmentMetadataArgs>) {
        this.intuneEnrollmentMetadata = value
    }

    /**
     * @param value Metadata used to generate draft package folder and scripts.
     */
    @JvmName("lfqmburbaqnhvepi")
    public suspend fun intuneMetadata(`value`: Output<DraftPackageIntuneAppMetadataArgs>) {
        this.intuneMetadata = value
    }

    /**
     * @param value Specifies the package id from which the draft package copied.
     */
    @JvmName("bxcparobltjooxli")
    public suspend fun packageId(`value`: Output<String>) {
        this.packageId = value
    }

    /**
     * @param value Tags of the package to be created.
     */
    @JvmName("mvkgrcpxuhhyctao")
    public suspend fun packageTags(`value`: Output<Map<String, String>>) {
        this.packageTags = value
    }

    /**
     * @param value The process name for script auto-fill. Will be used to identify the application process.
     */
    @JvmName("dcrhefswoljobbik")
    public suspend fun processName(`value`: Output<String>) {
        this.processName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qnmnryfevypnjxha")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The source type.
     */
    @JvmName("cwwyukowehngpslj")
    public suspend fun sourceType(`value`: Output<Either<String, DraftPackageSourceType>>) {
        this.sourceType = value
    }

    /**
     * @param value Tab state.
     */
    @JvmName("njsyajevjokdkwpi")
    public suspend fun tabState(`value`: Output<TabStateArgs>) {
        this.tabState = value
    }

    /**
     * @param value Specifies the target OSs of specific OS Update types.
     */
    @JvmName("fjhyqtbowalyjksy")
    public suspend fun targetOSList(`value`: Output<List<TargetOSInfoArgs>>) {
        this.targetOSList = value
    }

    @JvmName("pmpiladyabtarkle")
    public suspend fun targetOSList(vararg values: Output<TargetOSInfoArgs>) {
        this.targetOSList = Output.all(values.asList())
    }

    /**
     * @param values Specifies the target OSs of specific OS Update types.
     */
    @JvmName("vglnkieloatthmny")
    public suspend fun targetOSList(values: List<Output<TargetOSInfoArgs>>) {
        this.targetOSList = Output.all(values)
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("fxnpuxtccnhqvnxf")
    public suspend fun testBaseAccountName(`value`: Output<String>) {
        this.testBaseAccountName = value
    }

    /**
     * @param value OOB, functional or flow driven. Mapped to the data in 'tests' property.
     */
    @JvmName("eavmwyltrkuabnwk")
    public suspend fun testTypes(`value`: Output<List<Either<String, TestType>>>) {
        this.testTypes = value
    }

    @JvmName("cwwpyqkjxsdothkj")
    public suspend fun testTypes(vararg values: Output<Either<String, TestType>>) {
        this.testTypes = Output.all(values.asList())
    }

    /**
     * @param values OOB, functional or flow driven. Mapped to the data in 'tests' property.
     */
    @JvmName("phtwjlcuqexpskpi")
    public suspend fun testTypes(values: List<Output<Either<String, TestType>>>) {
        this.testTypes = Output.all(values)
    }

    /**
     * @param value The detailed test information.
     */
    @JvmName("gbqckcsknfxghrna")
    public suspend fun tests(`value`: Output<List<TestArgs>>) {
        this.tests = value
    }

    @JvmName("quhbivjkdwohosmi")
    public suspend fun tests(vararg values: Output<TestArgs>) {
        this.tests = Output.all(values.asList())
    }

    /**
     * @param values The detailed test information.
     */
    @JvmName("weqpubqdkyynltik")
    public suspend fun tests(values: List<Output<TestArgs>>) {
        this.tests = Output.all(values)
    }

    /**
     * @param value Indicates whether user choose to enable script auto-fill.
     */
    @JvmName("dpjqhlnulpohbkiq")
    public suspend fun useAutofill(`value`: Output<Boolean>) {
        this.useAutofill = value
    }

    /**
     * @param value Specifies whether a sample package should be used instead of the one uploaded by the user.
     */
    @JvmName("pefcqucqgyfahagp")
    public suspend fun useSample(`value`: Output<Boolean>) {
        this.useSample = value
    }

    /**
     * @param value Application version
     */
    @JvmName("jvpyqcytcporuagt")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The name of the app file.
     */
    @JvmName("tnyouyrrkisdmmfb")
    public suspend fun appFileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appFileName = mapped
    }

    /**
     * @param value Application name
     */
    @JvmName("agqmvhdwhjndkvil")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value Comments added by user.
     */
    @JvmName("aenssekpjiilscdp")
    public suspend fun comments(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comments = mapped
    }

    /**
     * @param value The resource name of the Test Base Draft Package.
     */
    @JvmName("abbdrxmnydkdxtdr")
    public suspend fun draftPackageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.draftPackageName = mapped
    }

    /**
     * @param value Specifies whether this draft package is used to edit a package.
     */
    @JvmName("ghnuptxsyowinwfq")
    public suspend fun editPackage(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.editPackage = mapped
    }

    /**
     * @param value The executable launch command for script auto-fill. Will be used to run the application.
     */
    @JvmName("xsmpnxcapaovblvo")
    public suspend fun executableLaunchCommand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executableLaunchCommand = mapped
    }

    /**
     * @param value The list of first party applications to test along with user application.
     */
    @JvmName("qgomlcejalaqjiyx")
    public suspend fun firstPartyApps(`value`: List<FirstPartyAppDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstPartyApps = mapped
    }

    /**
     * @param argument The list of first party applications to test along with user application.
     */
    @JvmName("qaiphsgbgxhyqsam")
    public suspend fun firstPartyApps(argument: List<suspend FirstPartyAppDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirstPartyAppDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.firstPartyApps = mapped
    }

    /**
     * @param argument The list of first party applications to test along with user application.
     */
    @JvmName("rgrvwanfijlbnagy")
    public suspend fun firstPartyApps(vararg argument: suspend FirstPartyAppDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FirstPartyAppDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.firstPartyApps = mapped
    }

    /**
     * @param argument The list of first party applications to test along with user application.
     */
    @JvmName("dqaolpidljksayha")
    public suspend fun firstPartyApps(argument: suspend FirstPartyAppDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FirstPartyAppDefinitionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.firstPartyApps = mapped
    }

    /**
     * @param values The list of first party applications to test along with user application.
     */
    @JvmName("bxfotfmrinwvppkr")
    public suspend fun firstPartyApps(vararg values: FirstPartyAppDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.firstPartyApps = mapped
    }

    /**
     * @param value The flighting ring for feature update.
     */
    @JvmName("xnvruihilllnaurh")
    public suspend fun flightingRing(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flightingRing = mapped
    }

    /**
     * @param value The list of gallery apps to test along with user application.
     */
    @JvmName("jugwmyifmopphcul")
    public suspend fun galleryApps(`value`: List<GalleryAppDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.galleryApps = mapped
    }

    /**
     * @param argument The list of gallery apps to test along with user application.
     */
    @JvmName("afwaoybyqwbxximv")
    public suspend fun galleryApps(argument: List<suspend GalleryAppDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GalleryAppDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.galleryApps = mapped
    }

    /**
     * @param argument The list of gallery apps to test along with user application.
     */
    @JvmName("cbeqwirjyypvdlqk")
    public suspend fun galleryApps(vararg argument: suspend GalleryAppDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GalleryAppDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.galleryApps = mapped
    }

    /**
     * @param argument The list of gallery apps to test along with user application.
     */
    @JvmName("sfhwjjtahfgyeuup")
    public suspend fun galleryApps(argument: suspend GalleryAppDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(GalleryAppDefinitionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.galleryApps = mapped
    }

    /**
     * @param values The list of gallery apps to test along with user application.
     */
    @JvmName("pemxvrgtbwnrnlva")
    public suspend fun galleryApps(vararg values: GalleryAppDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.galleryApps = mapped
    }

    /**
     * @param value The highlight files in the package.
     */
    @JvmName("ikcbwcyhxffsbsue")
    public suspend fun highlightedFiles(`value`: List<HighlightedFileArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.highlightedFiles = mapped
    }

    /**
     * @param argument The highlight files in the package.
     */
    @JvmName("nrvduuippnnrsaal")
    public suspend fun highlightedFiles(argument: List<suspend HighlightedFileArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HighlightedFileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.highlightedFiles = mapped
    }

    /**
     * @param argument The highlight files in the package.
     */
    @JvmName("uxatonfgeklkypgi")
    public suspend fun highlightedFiles(vararg argument: suspend HighlightedFileArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            HighlightedFileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.highlightedFiles = mapped
    }

    /**
     * @param argument The highlight files in the package.
     */
    @JvmName("agkhuksmrejiqlom")
    public suspend fun highlightedFiles(argument: suspend HighlightedFileArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(HighlightedFileArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.highlightedFiles = mapped
    }

    /**
     * @param values The highlight files in the package.
     */
    @JvmName("myxyxrhfjejsrgkr")
    public suspend fun highlightedFiles(vararg values: HighlightedFileArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.highlightedFiles = mapped
    }

    /**
     * @param value Specifies the baseline os and target os for inplace upgrade.
     */
    @JvmName("ysorwymavyfuelie")
    public suspend fun inplaceUpgradeOSPair(`value`: InplaceUpgradeOSInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inplaceUpgradeOSPair = mapped
    }

    /**
     * @param argument Specifies the baseline os and target os for inplace upgrade.
     */
    @JvmName("borfroavtpyuaqfa")
    public suspend fun inplaceUpgradeOSPair(argument: suspend InplaceUpgradeOSInfoArgsBuilder.() -> Unit) {
        val toBeMapped = InplaceUpgradeOSInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.inplaceUpgradeOSPair = mapped
    }

    /**
     * @param value The metadata of Intune enrollment.
     */
    @JvmName("mgxdylywrfranbfy")
    public suspend fun intuneEnrollmentMetadata(`value`: IntuneEnrollmentMetadataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intuneEnrollmentMetadata = mapped
    }

    /**
     * @param argument The metadata of Intune enrollment.
     */
    @JvmName("vacqaytciolhrrda")
    public suspend fun intuneEnrollmentMetadata(argument: suspend IntuneEnrollmentMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = IntuneEnrollmentMetadataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.intuneEnrollmentMetadata = mapped
    }

    /**
     * @param value Metadata used to generate draft package folder and scripts.
     */
    @JvmName("rvljqntmkfeknpwp")
    public suspend fun intuneMetadata(`value`: DraftPackageIntuneAppMetadataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intuneMetadata = mapped
    }

    /**
     * @param argument Metadata used to generate draft package folder and scripts.
     */
    @JvmName("xnfviqyxfasohphx")
    public suspend fun intuneMetadata(argument: suspend DraftPackageIntuneAppMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = DraftPackageIntuneAppMetadataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.intuneMetadata = mapped
    }

    /**
     * @param value Specifies the package id from which the draft package copied.
     */
    @JvmName("siesprnyugemgnwv")
    public suspend fun packageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageId = mapped
    }

    /**
     * @param value Tags of the package to be created.
     */
    @JvmName("lemqhehavvtvmywb")
    public suspend fun packageTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageTags = mapped
    }

    /**
     * @param values Tags of the package to be created.
     */
    @JvmName("dgrxbtgnwqgbqpuy")
    public fun packageTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.packageTags = mapped
    }

    /**
     * @param value The process name for script auto-fill. Will be used to identify the application process.
     */
    @JvmName("qocyldfwndykxjui")
    public suspend fun processName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hdmtlhviswwfaray")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The source type.
     */
    @JvmName("fxsnccnwtfoknulv")
    public suspend fun sourceType(`value`: Either<String, DraftPackageSourceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value The source type.
     */
    @JvmName("bfxhiafdkjnhyoks")
    public fun sourceType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DraftPackageSourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value The source type.
     */
    @JvmName("uecswrlgqxmttgxg")
    public fun sourceType(`value`: DraftPackageSourceType) {
        val toBeMapped = Either.ofRight<String, DraftPackageSourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value Tab state.
     */
    @JvmName("fgowatcuhhikddyr")
    public suspend fun tabState(`value`: TabStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tabState = mapped
    }

    /**
     * @param argument Tab state.
     */
    @JvmName("xvyctkiqhkogiomh")
    public suspend fun tabState(argument: suspend TabStateArgsBuilder.() -> Unit) {
        val toBeMapped = TabStateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tabState = mapped
    }

    /**
     * @param value Specifies the target OSs of specific OS Update types.
     */
    @JvmName("glpiqqpbooixhonu")
    public suspend fun targetOSList(`value`: List<TargetOSInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetOSList = mapped
    }

    /**
     * @param argument Specifies the target OSs of specific OS Update types.
     */
    @JvmName("haboipxxcyevphaj")
    public suspend fun targetOSList(argument: List<suspend TargetOSInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TargetOSInfoArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetOSList = mapped
    }

    /**
     * @param argument Specifies the target OSs of specific OS Update types.
     */
    @JvmName("dltduucblcbmyfmq")
    public suspend fun targetOSList(vararg argument: suspend TargetOSInfoArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TargetOSInfoArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetOSList = mapped
    }

    /**
     * @param argument Specifies the target OSs of specific OS Update types.
     */
    @JvmName("wquydlurtialpavg")
    public suspend fun targetOSList(argument: suspend TargetOSInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TargetOSInfoArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.targetOSList = mapped
    }

    /**
     * @param values Specifies the target OSs of specific OS Update types.
     */
    @JvmName("wjhjqwrxidcgijho")
    public suspend fun targetOSList(vararg values: TargetOSInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetOSList = mapped
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("xbhfeshoqnsxftfc")
    public suspend fun testBaseAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testBaseAccountName = mapped
    }

    /**
     * @param value OOB, functional or flow driven. Mapped to the data in 'tests' property.
     */
    @JvmName("lcskccectlxlnwho")
    public suspend fun testTypes(`value`: List<Either<String, TestType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testTypes = mapped
    }

    /**
     * @param values OOB, functional or flow driven. Mapped to the data in 'tests' property.
     */
    @JvmName("ivdpeowcepglqbyb")
    public suspend fun testTypes(vararg values: Either<String, TestType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.testTypes = mapped
    }

    /**
     * @param value The detailed test information.
     */
    @JvmName("prukygpkjpasacvx")
    public suspend fun tests(`value`: List<TestArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tests = mapped
    }

    /**
     * @param argument The detailed test information.
     */
    @JvmName("tnkxmgvtncvntydh")
    public suspend fun tests(argument: List<suspend TestArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { TestArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.tests = mapped
    }

    /**
     * @param argument The detailed test information.
     */
    @JvmName("rnoosjmldredsyfj")
    public suspend fun tests(vararg argument: suspend TestArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { TestArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.tests = mapped
    }

    /**
     * @param argument The detailed test information.
     */
    @JvmName("ssyuqigdonejtubm")
    public suspend fun tests(argument: suspend TestArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TestArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.tests = mapped
    }

    /**
     * @param values The detailed test information.
     */
    @JvmName("kcypdopfshywfjyg")
    public suspend fun tests(vararg values: TestArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tests = mapped
    }

    /**
     * @param value Indicates whether user choose to enable script auto-fill.
     */
    @JvmName("biwwixeiqioesuql")
    public suspend fun useAutofill(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useAutofill = mapped
    }

    /**
     * @param value Specifies whether a sample package should be used instead of the one uploaded by the user.
     */
    @JvmName("oelwydlhibeyguhg")
    public suspend fun useSample(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useSample = mapped
    }

    /**
     * @param value Application version
     */
    @JvmName("hmqseiuuilwfciyp")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): DraftPackageArgs = DraftPackageArgs(
        appFileName = appFileName,
        applicationName = applicationName,
        comments = comments,
        draftPackageName = draftPackageName,
        editPackage = editPackage,
        executableLaunchCommand = executableLaunchCommand,
        firstPartyApps = firstPartyApps,
        flightingRing = flightingRing,
        galleryApps = galleryApps,
        highlightedFiles = highlightedFiles,
        inplaceUpgradeOSPair = inplaceUpgradeOSPair,
        intuneEnrollmentMetadata = intuneEnrollmentMetadata,
        intuneMetadata = intuneMetadata,
        packageId = packageId,
        packageTags = packageTags,
        processName = processName,
        resourceGroupName = resourceGroupName,
        sourceType = sourceType,
        tabState = tabState,
        targetOSList = targetOSList,
        testBaseAccountName = testBaseAccountName,
        testTypes = testTypes,
        tests = tests,
        useAutofill = useAutofill,
        useSample = useSample,
        version = version,
    )
}
