@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin

import com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ImageDefinition].
 */
@PulumiTagMarker
public class ImageDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ImageDefinitionArgs = ImageDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ImageDefinitionArgsBuilder.() -> Unit) {
        val builder = ImageDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ImageDefinition {
        val builtJavaResource = com.pulumi.azurenative.testbase.ImageDefinition(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ImageDefinition(builtJavaResource)
    }
}

/**
 * The test base image definition resource.
 * Azure REST API version: 2023-11-01-preview.
 * ## Example Usage
 * ### ImageDefinitionCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var imageDefinition = new AzureNative.TestBase.ImageDefinition("imageDefinition", new()
 *     {
 *         Architecture = AzureNative.TestBase.ImageArchitecture.X64,
 *         ImageDefinitionName = "contoso-image-def",
 *         OsState = AzureNative.TestBase.ImageOSState.Generalized,
 *         ResourceGroupName = "contoso-rg1",
 *         SecurityType = AzureNative.TestBase.ImageSecurityType.Standard,
 *         TestBaseAccountName = "contoso-testBaseAccount1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/testbase/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := testbase.NewImageDefinition(ctx, "imageDefinition", &testbase.ImageDefinitionArgs{
 * 			Architecture:        pulumi.String(testbase.ImageArchitectureX64),
 * 			ImageDefinitionName: pulumi.String("contoso-image-def"),
 * 			OsState:             pulumi.String(testbase.ImageOSStateGeneralized),
 * 			ResourceGroupName:   pulumi.String("contoso-rg1"),
 * 			SecurityType:        pulumi.String(testbase.ImageSecurityTypeStandard),
 * 			TestBaseAccountName: pulumi.String("contoso-testBaseAccount1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.testbase.ImageDefinition;
 * import com.pulumi.azurenative.testbase.ImageDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var imageDefinition = new ImageDefinition("imageDefinition", ImageDefinitionArgs.builder()
 *             .architecture("x64")
 *             .imageDefinitionName("contoso-image-def")
 *             .osState("Generalized")
 *             .resourceGroupName("contoso-rg1")
 *             .securityType("Standard")
 *             .testBaseAccountName("contoso-testBaseAccount1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:testbase:ImageDefinition contoso-image-def /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/imageDefinitions/{imageDefinitionName}
 * ```
 */
public class ImageDefinition internal constructor(
    override val javaResource: com.pulumi.azurenative.testbase.ImageDefinition,
) : KotlinCustomResource(javaResource, ImageDefinitionMapper) {
    /**
     * Custom image architecture.
     */
    public val architecture: Output<String>
        get() = javaResource.architecture().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Custom image OS state.
     */
    public val osState: Output<String>
        get() = javaResource.osState().applyValue({ args0 -> args0 })

    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Custom image security type.
     */
    public val securityType: Output<String>
        get() = javaResource.securityType().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ImageDefinitionMapper : ResourceMapper<ImageDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.testbase.ImageDefinition::class == javaResource::class

    override fun map(javaResource: Resource): ImageDefinition = ImageDefinition(
        javaResource as
            com.pulumi.azurenative.testbase.ImageDefinition,
    )
}

/**
 * @see [ImageDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ImageDefinition].
 */
public suspend fun imageDefinition(
    name: String,
    block: suspend ImageDefinitionResourceBuilder.() -> Unit,
): ImageDefinition {
    val builder = ImageDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ImageDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun imageDefinition(name: String): ImageDefinition {
    val builder = ImageDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
