@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin

import com.pulumi.azurenative.testbase.ImageDefinitionArgs.builder
import com.pulumi.azurenative.testbase.kotlin.enums.ImageArchitecture
import com.pulumi.azurenative.testbase.kotlin.enums.ImageOSState
import com.pulumi.azurenative.testbase.kotlin.enums.ImageSecurityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The test base image definition resource.
 * Azure REST API version: 2023-11-01-preview.
 * ## Example Usage
 * ### ImageDefinitionCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var imageDefinition = new AzureNative.TestBase.ImageDefinition("imageDefinition", new()
 *     {
 *         Architecture = AzureNative.TestBase.ImageArchitecture.X64,
 *         ImageDefinitionName = "contoso-image-def",
 *         OsState = AzureNative.TestBase.ImageOSState.Generalized,
 *         ResourceGroupName = "contoso-rg1",
 *         SecurityType = AzureNative.TestBase.ImageSecurityType.Standard,
 *         TestBaseAccountName = "contoso-testBaseAccount1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/testbase/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := testbase.NewImageDefinition(ctx, "imageDefinition", &testbase.ImageDefinitionArgs{
 * 			Architecture:        pulumi.String(testbase.ImageArchitectureX64),
 * 			ImageDefinitionName: pulumi.String("contoso-image-def"),
 * 			OsState:             pulumi.String(testbase.ImageOSStateGeneralized),
 * 			ResourceGroupName:   pulumi.String("contoso-rg1"),
 * 			SecurityType:        pulumi.String(testbase.ImageSecurityTypeStandard),
 * 			TestBaseAccountName: pulumi.String("contoso-testBaseAccount1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.testbase.ImageDefinition;
 * import com.pulumi.azurenative.testbase.ImageDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var imageDefinition = new ImageDefinition("imageDefinition", ImageDefinitionArgs.builder()
 *             .architecture("x64")
 *             .imageDefinitionName("contoso-image-def")
 *             .osState("Generalized")
 *             .resourceGroupName("contoso-rg1")
 *             .securityType("Standard")
 *             .testBaseAccountName("contoso-testBaseAccount1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:testbase:ImageDefinition contoso-image-def /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/imageDefinitions/{imageDefinitionName}
 * ```
 * @property architecture Custom image architecture.
 * @property imageDefinitionName The resource name of the test base image definition.
 * @property osState Custom image OS state.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property securityType Custom image security type.
 * @property testBaseAccountName The resource name of the Test Base Account.
 */
public data class ImageDefinitionArgs(
    public val architecture: Output<Either<String, ImageArchitecture>>? = null,
    public val imageDefinitionName: Output<String>? = null,
    public val osState: Output<Either<String, ImageOSState>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val securityType: Output<Either<String, ImageSecurityType>>? = null,
    public val testBaseAccountName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.ImageDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.ImageDefinitionArgs =
        com.pulumi.azurenative.testbase.ImageDefinitionArgs.builder()
            .architecture(
                architecture?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .imageDefinitionName(imageDefinitionName?.applyValue({ args0 -> args0 }))
            .osState(
                osState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .securityType(
                securityType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .testBaseAccountName(testBaseAccountName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageDefinitionArgs].
 */
@PulumiTagMarker
public class ImageDefinitionArgsBuilder internal constructor() {
    private var architecture: Output<Either<String, ImageArchitecture>>? = null

    private var imageDefinitionName: Output<String>? = null

    private var osState: Output<Either<String, ImageOSState>>? = null

    private var resourceGroupName: Output<String>? = null

    private var securityType: Output<Either<String, ImageSecurityType>>? = null

    private var testBaseAccountName: Output<String>? = null

    /**
     * @param value Custom image architecture.
     */
    @JvmName("ckavkwrvgkopsglx")
    public suspend fun architecture(`value`: Output<Either<String, ImageArchitecture>>) {
        this.architecture = value
    }

    /**
     * @param value The resource name of the test base image definition.
     */
    @JvmName("tawfnwrxhjdsoxtk")
    public suspend fun imageDefinitionName(`value`: Output<String>) {
        this.imageDefinitionName = value
    }

    /**
     * @param value Custom image OS state.
     */
    @JvmName("jncvdatdnguquwxg")
    public suspend fun osState(`value`: Output<Either<String, ImageOSState>>) {
        this.osState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("peeaereawrthiiym")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Custom image security type.
     */
    @JvmName("dnxmgtkchfjoymvq")
    public suspend fun securityType(`value`: Output<Either<String, ImageSecurityType>>) {
        this.securityType = value
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("amlwxquoafvunuqy")
    public suspend fun testBaseAccountName(`value`: Output<String>) {
        this.testBaseAccountName = value
    }

    /**
     * @param value Custom image architecture.
     */
    @JvmName("gbsixvjnndnvtktw")
    public suspend fun architecture(`value`: Either<String, ImageArchitecture>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.architecture = mapped
    }

    /**
     * @param value Custom image architecture.
     */
    @JvmName("hdlatrvrfdlydqvh")
    public fun architecture(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ImageArchitecture>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.architecture = mapped
    }

    /**
     * @param value Custom image architecture.
     */
    @JvmName("ufsnkrupemtvbrrn")
    public fun architecture(`value`: ImageArchitecture) {
        val toBeMapped = Either.ofRight<String, ImageArchitecture>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.architecture = mapped
    }

    /**
     * @param value The resource name of the test base image definition.
     */
    @JvmName("jodlbafshrujiacd")
    public suspend fun imageDefinitionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageDefinitionName = mapped
    }

    /**
     * @param value Custom image OS state.
     */
    @JvmName("lrnomjtomsmhflop")
    public suspend fun osState(`value`: Either<String, ImageOSState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osState = mapped
    }

    /**
     * @param value Custom image OS state.
     */
    @JvmName("xwhjlgtqnybkcywk")
    public fun osState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ImageOSState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osState = mapped
    }

    /**
     * @param value Custom image OS state.
     */
    @JvmName("fncwpiigdupliwln")
    public fun osState(`value`: ImageOSState) {
        val toBeMapped = Either.ofRight<String, ImageOSState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tufonwunffjcckbf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Custom image security type.
     */
    @JvmName("kdbhfcblowbsgmli")
    public suspend fun securityType(`value`: Either<String, ImageSecurityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityType = mapped
    }

    /**
     * @param value Custom image security type.
     */
    @JvmName("scycjmxivjbviwtj")
    public fun securityType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ImageSecurityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityType = mapped
    }

    /**
     * @param value Custom image security type.
     */
    @JvmName("xndlmppnpxvgghvr")
    public fun securityType(`value`: ImageSecurityType) {
        val toBeMapped = Either.ofRight<String, ImageSecurityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityType = mapped
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("qgunrauxgnsmogex")
    public suspend fun testBaseAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testBaseAccountName = mapped
    }

    internal fun build(): ImageDefinitionArgs = ImageDefinitionArgs(
        architecture = architecture,
        imageDefinitionName = imageDefinitionName,
        osState = osState,
        resourceGroupName = resourceGroupName,
        securityType = securityType,
        testBaseAccountName = testBaseAccountName,
    )
}
