@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin

import com.pulumi.azurenative.testbase.PackageArgs.builder
import com.pulumi.azurenative.testbase.kotlin.inputs.TargetOSInfoArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.TargetOSInfoArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.TestArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.TestArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The Test Base Package resource.
 * Azure REST API version: 2022-04-01-preview. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2023-11-01-preview.
 * ## Example Usage
 * ### PackageCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var package = new AzureNative.TestBase.Package("package", new()
 *     {
 *         ApplicationName = "contoso-package2",
 *         BlobPath = "storageAccountPath/package.zip",
 *         FlightingRing = "Insider Beta Channel",
 *         Location = "westus",
 *         PackageName = "contoso-package2",
 *         ResourceGroupName = "contoso-rg1",
 *         Tags = null,
 *         TargetOSList = new[]
 *         {
 *             new AzureNative.TestBase.Inputs.TargetOSInfoArgs
 *             {
 *                 OsUpdateType = "Security updates",
 *                 TargetOSs = new[]
 *                 {
 *                     "Windows 10 2004",
 *                     "Windows 10 1903",
 *                 },
 *             },
 *         },
 *         TestBaseAccountName = "contoso-testBaseAccount1",
 *         Tests = new[]
 *         {
 *             new AzureNative.TestBase.Inputs.TestArgs
 *             {
 *                 Commands = new[]
 *                 {
 *                     new AzureNative.TestBase.Inputs.CommandArgs
 *                     {
 *                         Action = AzureNative.TestBase.Action.Install,
 *                         AlwaysRun = true,
 *                         ApplyUpdateBefore = false,
 *                         Content = "app/scripts/install/job.ps1",
 *                         ContentType = AzureNative.TestBase.ContentType.Path,
 *                         MaxRunTime = 1800,
 *                         Name = "Install",
 *                         RestartAfter = true,
 *                         RunAsInteractive = true,
 *                         RunElevated = true,
 *                     },
 *                     new AzureNative.TestBase.Inputs.CommandArgs
 *                     {
 *                         Action = AzureNative.TestBase.Action.Launch,
 *                         AlwaysRun = false,
 *                         ApplyUpdateBefore = true,
 *                         Content = "app/scripts/launch/job.ps1",
 *                         ContentType = AzureNative.TestBase.ContentType.Path,
 *                         MaxRunTime = 1800,
 *                         Name = "Launch",
 *                         RestartAfter = false,
 *                         RunAsInteractive = true,
 *                         RunElevated = true,
 *                     },
 *                     new AzureNative.TestBase.Inputs.CommandArgs
 *                     {
 *                         Action = AzureNative.TestBase.Action.Close,
 *                         AlwaysRun = false,
 *                         ApplyUpdateBefore = false,
 *                         Content = "app/scripts/close/job.ps1",
 *                         ContentType = AzureNative.TestBase.ContentType.Path,
 *                         MaxRunTime = 1800,
 *                         Name = "Close",
 *                         RestartAfter = false,
 *                         RunAsInteractive = true,
 *                         RunElevated = true,
 *                     },
 *                     new AzureNative.TestBase.Inputs.CommandArgs
 *                     {
 *                         Action = AzureNative.TestBase.Action.Uninstall,
 *                         AlwaysRun = true,
 *                         ApplyUpdateBefore = false,
 *                         Content = "app/scripts/uninstall/job.ps1",
 *                         ContentType = AzureNative.TestBase.ContentType.Path,
 *                         MaxRunTime = 1800,
 *                         Name = "Uninstall",
 *                         RestartAfter = false,
 *                         RunAsInteractive = true,
 *                         RunElevated = true,
 *                     },
 *                 },
 *                 IsActive = true,
 *                 TestType = AzureNative.TestBase.TestType.OutOfBoxTest,
 *             },
 *         },
 *         Version = "1.0.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/testbase/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := testbase.NewPackage(ctx, "package", &testbase.PackageArgs{
 * 			ApplicationName:   pulumi.String("contoso-package2"),
 * 			BlobPath:          pulumi.String("storageAccountPath/package.zip"),
 * 			FlightingRing:     pulumi.String("Insider Beta Channel"),
 * 			Location:          pulumi.String("westus"),
 * 			PackageName:       pulumi.String("contoso-package2"),
 * 			ResourceGroupName: pulumi.String("contoso-rg1"),
 * 			Tags:              nil,
 * 			TargetOSList: testbase.TargetOSInfoArray{
 * 				&testbase.TargetOSInfoArgs{
 * 					OsUpdateType: pulumi.String("Security updates"),
 * 					TargetOSs: pulumi.StringArray{
 * 						pulumi.String("Windows 10 2004"),
 * 						pulumi.String("Windows 10 1903"),
 * 					},
 * 				},
 * 			},
 * 			TestBaseAccountName: pulumi.String("contoso-testBaseAccount1"),
 * 			Tests: testbase.TestArray{
 * 				&testbase.TestArgs{
 * 					Commands: testbase.CommandArray{
 * 						&testbase.CommandArgs{
 * 							Action:            pulumi.String(testbase.ActionInstall),
 * 							AlwaysRun:         pulumi.Bool(true),
 * 							ApplyUpdateBefore: pulumi.Bool(false),
 * 							Content:           pulumi.String("app/scripts/install/job.ps1"),
 * 							ContentType:       pulumi.String(testbase.ContentTypePath),
 * 							MaxRunTime:        pulumi.Int(1800),
 * 							Name:              pulumi.String("Install"),
 * 							RestartAfter:      pulumi.Bool(true),
 * 							RunAsInteractive:  pulumi.Bool(true),
 * 							RunElevated:       pulumi.Bool(true),
 * 						},
 * 						&testbase.CommandArgs{
 * 							Action:            pulumi.String(testbase.ActionLaunch),
 * 							AlwaysRun:         pulumi.Bool(false),
 * 							ApplyUpdateBefore: pulumi.Bool(true),
 * 							Content:           pulumi.String("app/scripts/launch/job.ps1"),
 * 							ContentType:       pulumi.String(testbase.ContentTypePath),
 * 							MaxRunTime:        pulumi.Int(1800),
 * 							Name:              pulumi.String("Launch"),
 * 							RestartAfter:      pulumi.Bool(false),
 * 							RunAsInteractive:  pulumi.Bool(true),
 * 							RunElevated:       pulumi.Bool(true),
 * 						},
 * 						&testbase.CommandArgs{
 * 							Action:            pulumi.String(testbase.ActionClose),
 * 							AlwaysRun:         pulumi.Bool(false),
 * 							ApplyUpdateBefore: pulumi.Bool(false),
 * 							Content:           pulumi.String("app/scripts/close/job.ps1"),
 * 							ContentType:       pulumi.String(testbase.ContentTypePath),
 * 							MaxRunTime:        pulumi.Int(1800),
 * 							Name:              pulumi.String("Close"),
 * 							RestartAfter:      pulumi.Bool(false),
 * 							RunAsInteractive:  pulumi.Bool(true),
 * 							RunElevated:       pulumi.Bool(true),
 * 						},
 * 						&testbase.CommandArgs{
 * 							Action:            pulumi.String(testbase.ActionUninstall),
 * 							AlwaysRun:         pulumi.Bool(true),
 * 							ApplyUpdateBefore: pulumi.Bool(false),
 * 							Content:           pulumi.String("app/scripts/uninstall/job.ps1"),
 * 							ContentType:       pulumi.String(testbase.ContentTypePath),
 * 							MaxRunTime:        pulumi.Int(1800),
 * 							Name:              pulumi.String("Uninstall"),
 * 							RestartAfter:      pulumi.Bool(false),
 * 							RunAsInteractive:  pulumi.Bool(true),
 * 							RunElevated:       pulumi.Bool(true),
 * 						},
 * 					},
 * 					IsActive: pulumi.Bool(true),
 * 					TestType: pulumi.String(testbase.TestTypeOutOfBoxTest),
 * 				},
 * 			},
 * 			Version: pulumi.String("1.0.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.testbase.Package;
 * import com.pulumi.azurenative.testbase.PackageArgs;
 * import com.pulumi.azurenative.testbase.inputs.TargetOSInfoArgs;
 * import com.pulumi.azurenative.testbase.inputs.TestArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var package_ = new Package("package", PackageArgs.builder()
 *             .applicationName("contoso-package2")
 *             .blobPath("storageAccountPath/package.zip")
 *             .flightingRing("Insider Beta Channel")
 *             .location("westus")
 *             .packageName("contoso-package2")
 *             .resourceGroupName("contoso-rg1")
 *             .tags()
 *             .targetOSList(TargetOSInfoArgs.builder()
 *                 .osUpdateType("Security updates")
 *                 .targetOSs(
 *                     "Windows 10 2004",
 *                     "Windows 10 1903")
 *                 .build())
 *             .testBaseAccountName("contoso-testBaseAccount1")
 *             .tests(TestArgs.builder()
 *                 .commands(
 *                     CommandArgs.builder()
 *                         .action("Install")
 *                         .alwaysRun(true)
 *                         .applyUpdateBefore(false)
 *                         .content("app/scripts/install/job.ps1")
 *                         .contentType("Path")
 *                         .maxRunTime(1800)
 *                         .name("Install")
 *                         .restartAfter(true)
 *                         .runAsInteractive(true)
 *                         .runElevated(true)
 *                         .build(),
 *                     CommandArgs.builder()
 *                         .action("Launch")
 *                         .alwaysRun(false)
 *                         .applyUpdateBefore(true)
 *                         .content("app/scripts/launch/job.ps1")
 *                         .contentType("Path")
 *                         .maxRunTime(1800)
 *                         .name("Launch")
 *                         .restartAfter(false)
 *                         .runAsInteractive(true)
 *                         .runElevated(true)
 *                         .build(),
 *                     CommandArgs.builder()
 *                         .action("Close")
 *                         .alwaysRun(false)
 *                         .applyUpdateBefore(false)
 *                         .content("app/scripts/close/job.ps1")
 *                         .contentType("Path")
 *                         .maxRunTime(1800)
 *                         .name("Close")
 *                         .restartAfter(false)
 *                         .runAsInteractive(true)
 *                         .runElevated(true)
 *                         .build(),
 *                     CommandArgs.builder()
 *                         .action("Uninstall")
 *                         .alwaysRun(true)
 *                         .applyUpdateBefore(false)
 *                         .content("app/scripts/uninstall/job.ps1")
 *                         .contentType("Path")
 *                         .maxRunTime(1800)
 *                         .name("Uninstall")
 *                         .restartAfter(false)
 *                         .runAsInteractive(true)
 *                         .runElevated(true)
 *                         .build())
 *                 .isActive(true)
 *                 .testType("OutOfBoxTest")
 *                 .build())
 *             .version("1.0.0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:testbase:Package contoso-package2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}
 * ```
 * @property applicationName Application name
 * @property blobPath The file path of the package.
 * @property flightingRing The flighting ring for feature update.
 * @property location The geo-location where the resource lives
 * @property packageName The resource name of the Test Base Package.
 * @property resourceGroupName The name of the resource group that contains the resource.
 * @property tags The tags of the resource.
 * @property targetOSList Specifies the target OSs of specific OS Update types.
 * @property testBaseAccountName The resource name of the Test Base Account.
 * @property tests The detailed test information.
 * @property version Application version
 */
public data class PackageArgs(
    public val applicationName: Output<String>? = null,
    public val blobPath: Output<String>? = null,
    public val flightingRing: Output<String>? = null,
    public val location: Output<String>? = null,
    public val packageName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetOSList: Output<List<TargetOSInfoArgs>>? = null,
    public val testBaseAccountName: Output<String>? = null,
    public val tests: Output<List<TestArgs>>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.PackageArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.PackageArgs =
        com.pulumi.azurenative.testbase.PackageArgs.builder()
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .blobPath(blobPath?.applyValue({ args0 -> args0 }))
            .flightingRing(flightingRing?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .packageName(packageName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetOSList(
                targetOSList?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .testBaseAccountName(testBaseAccountName?.applyValue({ args0 -> args0 }))
            .tests(tests?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PackageArgs].
 */
@PulumiTagMarker
public class PackageArgsBuilder internal constructor() {
    private var applicationName: Output<String>? = null

    private var blobPath: Output<String>? = null

    private var flightingRing: Output<String>? = null

    private var location: Output<String>? = null

    private var packageName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetOSList: Output<List<TargetOSInfoArgs>>? = null

    private var testBaseAccountName: Output<String>? = null

    private var tests: Output<List<TestArgs>>? = null

    private var version: Output<String>? = null

    /**
     * @param value Application name
     */
    @JvmName("febkqxrtfhxadohr")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value The file path of the package.
     */
    @JvmName("mbpyfigmdmrxmwdj")
    public suspend fun blobPath(`value`: Output<String>) {
        this.blobPath = value
    }

    /**
     * @param value The flighting ring for feature update.
     */
    @JvmName("ngflqihtexrgulbu")
    public suspend fun flightingRing(`value`: Output<String>) {
        this.flightingRing = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ffffpexftlyhfueo")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The resource name of the Test Base Package.
     */
    @JvmName("lupwmobetldcceoc")
    public suspend fun packageName(`value`: Output<String>) {
        this.packageName = value
    }

    /**
     * @param value The name of the resource group that contains the resource.
     */
    @JvmName("tfntlfqyfvavtdlv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("girwayfwttcortjq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the target OSs of specific OS Update types.
     */
    @JvmName("jigwlgwbcrsltalk")
    public suspend fun targetOSList(`value`: Output<List<TargetOSInfoArgs>>) {
        this.targetOSList = value
    }

    @JvmName("kebwmvxqikfwvixi")
    public suspend fun targetOSList(vararg values: Output<TargetOSInfoArgs>) {
        this.targetOSList = Output.all(values.asList())
    }

    /**
     * @param values Specifies the target OSs of specific OS Update types.
     */
    @JvmName("rwyarqrktvtmtqup")
    public suspend fun targetOSList(values: List<Output<TargetOSInfoArgs>>) {
        this.targetOSList = Output.all(values)
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("nqhevorfevxkgkqh")
    public suspend fun testBaseAccountName(`value`: Output<String>) {
        this.testBaseAccountName = value
    }

    /**
     * @param value The detailed test information.
     */
    @JvmName("hfilsbevspuclayx")
    public suspend fun tests(`value`: Output<List<TestArgs>>) {
        this.tests = value
    }

    @JvmName("nijcoshbhqoxdxft")
    public suspend fun tests(vararg values: Output<TestArgs>) {
        this.tests = Output.all(values.asList())
    }

    /**
     * @param values The detailed test information.
     */
    @JvmName("wxrkrvamheqbkwsd")
    public suspend fun tests(values: List<Output<TestArgs>>) {
        this.tests = Output.all(values)
    }

    /**
     * @param value Application version
     */
    @JvmName("vrirrltesqcxqvnb")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Application name
     */
    @JvmName("jxbcjytatrvxtjpb")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value The file path of the package.
     */
    @JvmName("chipxsgulnitjpcf")
    public suspend fun blobPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobPath = mapped
    }

    /**
     * @param value The flighting ring for feature update.
     */
    @JvmName("ybgxwacsfcjitlhq")
    public suspend fun flightingRing(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flightingRing = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ugpmnkgyjxjmfxcl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The resource name of the Test Base Package.
     */
    @JvmName("rxtbniwrlhyfinqa")
    public suspend fun packageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource.
     */
    @JvmName("vslrwlpukcfwumaw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("jrevesgifgvhqxpv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("uarrnjljeclgouch")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies the target OSs of specific OS Update types.
     */
    @JvmName("dtcmorsqrsdaacdf")
    public suspend fun targetOSList(`value`: List<TargetOSInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetOSList = mapped
    }

    /**
     * @param argument Specifies the target OSs of specific OS Update types.
     */
    @JvmName("sviwdcbfvvpttbin")
    public suspend fun targetOSList(argument: List<suspend TargetOSInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TargetOSInfoArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetOSList = mapped
    }

    /**
     * @param argument Specifies the target OSs of specific OS Update types.
     */
    @JvmName("oyhjspinyphastmw")
    public suspend fun targetOSList(vararg argument: suspend TargetOSInfoArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TargetOSInfoArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetOSList = mapped
    }

    /**
     * @param argument Specifies the target OSs of specific OS Update types.
     */
    @JvmName("sbfftpyyqwuvmpil")
    public suspend fun targetOSList(argument: suspend TargetOSInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TargetOSInfoArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.targetOSList = mapped
    }

    /**
     * @param values Specifies the target OSs of specific OS Update types.
     */
    @JvmName("jjaksrhctodiijrd")
    public suspend fun targetOSList(vararg values: TargetOSInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetOSList = mapped
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("lpagkyjsfvxkdkke")
    public suspend fun testBaseAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testBaseAccountName = mapped
    }

    /**
     * @param value The detailed test information.
     */
    @JvmName("tabdmlexrwqewfxu")
    public suspend fun tests(`value`: List<TestArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tests = mapped
    }

    /**
     * @param argument The detailed test information.
     */
    @JvmName("jekcxlpeamngxiqd")
    public suspend fun tests(argument: List<suspend TestArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { TestArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.tests = mapped
    }

    /**
     * @param argument The detailed test information.
     */
    @JvmName("shrgxiivpxyefacn")
    public suspend fun tests(vararg argument: suspend TestArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { TestArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.tests = mapped
    }

    /**
     * @param argument The detailed test information.
     */
    @JvmName("ynhjpoitoaxudamg")
    public suspend fun tests(argument: suspend TestArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TestArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.tests = mapped
    }

    /**
     * @param values The detailed test information.
     */
    @JvmName("cyoymwmjibqcxhic")
    public suspend fun tests(vararg values: TestArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tests = mapped
    }

    /**
     * @param value Application version
     */
    @JvmName("wysctpnxpmrmfmlu")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): PackageArgs = PackageArgs(
        applicationName = applicationName,
        blobPath = blobPath,
        flightingRing = flightingRing,
        location = location,
        packageName = packageName,
        resourceGroupName = resourceGroupName,
        tags = tags,
        targetOSList = targetOSList,
        testBaseAccountName = testBaseAccountName,
        tests = tests,
        version = version,
    )
}
