@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin

import com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.testbase.kotlin.outputs.TestBaseAccountSKUResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.TestBaseAccountSKUResponse.Companion.toKotlin as testBaseAccountSKUResponseToKotlin

/**
 * Builder for [TestBaseAccount].
 */
@PulumiTagMarker
public class TestBaseAccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TestBaseAccountArgs = TestBaseAccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TestBaseAccountArgsBuilder.() -> Unit) {
        val builder = TestBaseAccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TestBaseAccount {
        val builtJavaResource = com.pulumi.azurenative.testbase.TestBaseAccount(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TestBaseAccount(builtJavaResource)
    }
}

/**
 * The Test Base Account resource.
 * Azure REST API version: 2022-04-01-preview. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2023-11-01-preview.
 * ## Example Usage
 * ### TestBaseAccountCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testBaseAccount = new AzureNative.TestBase.TestBaseAccount("testBaseAccount", new()
 *     {
 *         Location = "westus",
 *         ResourceGroupName = "contoso-rg1",
 *         Sku = new AzureNative.TestBase.Inputs.TestBaseAccountSKUArgs
 *         {
 *             Name = "S0",
 *             Tier = AzureNative.TestBase.Tier.Standard,
 *         },
 *         TestBaseAccountName = "contoso-testBaseAccount1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/testbase/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := testbase.NewTestBaseAccount(ctx, "testBaseAccount", &testbase.TestBaseAccountArgs{
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("contoso-rg1"),
 * 			Sku: &testbase.TestBaseAccountSKUArgs{
 * 				Name: pulumi.String("S0"),
 * 				Tier: pulumi.String(testbase.TierStandard),
 * 			},
 * 			TestBaseAccountName: pulumi.String("contoso-testBaseAccount1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.testbase.TestBaseAccount;
 * import com.pulumi.azurenative.testbase.TestBaseAccountArgs;
 * import com.pulumi.azurenative.testbase.inputs.TestBaseAccountSKUArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testBaseAccount = new TestBaseAccount("testBaseAccount", TestBaseAccountArgs.builder()
 *             .location("westus")
 *             .resourceGroupName("contoso-rg1")
 *             .sku(TestBaseAccountSKUArgs.builder()
 *                 .name("S0")
 *                 .tier("Standard")
 *                 .build())
 *             .testBaseAccountName("contoso-testBaseAccount1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:testbase:TestBaseAccount contoso-testBaseAccount1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}
 * ```
 */
public class TestBaseAccount internal constructor(
    override val javaResource: com.pulumi.azurenative.testbase.TestBaseAccount,
) : KotlinCustomResource(javaResource, TestBaseAccountMapper) {
    /**
     * The access level of the Test Base Account.
     */
    public val accessLevel: Output<String>
        get() = javaResource.accessLevel().applyValue({ args0 -> args0 })

    /**
     * Resource Etag.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The SKU of the Test Base Account.
     */
    public val sku: Output<TestBaseAccountSKUResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                testBaseAccountSKUResponseToKotlin(args0)
            })
        })

    /**
     * The system metadata relating to this resource
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TestBaseAccountMapper : ResourceMapper<TestBaseAccount> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.testbase.TestBaseAccount::class == javaResource::class

    override fun map(javaResource: Resource): TestBaseAccount = TestBaseAccount(
        javaResource as
            com.pulumi.azurenative.testbase.TestBaseAccount,
    )
}

/**
 * @see [TestBaseAccount].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TestBaseAccount].
 */
public suspend fun testBaseAccount(
    name: String,
    block: suspend TestBaseAccountResourceBuilder.() -> Unit,
): TestBaseAccount {
    val builder = TestBaseAccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TestBaseAccount].
 * @param name The _unique_ name of the resulting resource.
 */
public fun testBaseAccount(name: String): TestBaseAccount {
    val builder = TestBaseAccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
