@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin

import com.pulumi.azurenative.testbase.TestbaseFunctions.getActionRequestPlain
import com.pulumi.azurenative.testbase.TestbaseFunctions.getBillingHubServiceFreeHourBalancePlain
import com.pulumi.azurenative.testbase.TestbaseFunctions.getBillingHubServiceUsagePlain
import com.pulumi.azurenative.testbase.TestbaseFunctions.getCredentialPlain
import com.pulumi.azurenative.testbase.TestbaseFunctions.getCustomImagePlain
import com.pulumi.azurenative.testbase.TestbaseFunctions.getCustomerEventPlain
import com.pulumi.azurenative.testbase.TestbaseFunctions.getDraftPackagePathPlain
import com.pulumi.azurenative.testbase.TestbaseFunctions.getDraftPackagePlain
import com.pulumi.azurenative.testbase.TestbaseFunctions.getFavoriteProcessPlain
import com.pulumi.azurenative.testbase.TestbaseFunctions.getImageDefinitionPlain
import com.pulumi.azurenative.testbase.TestbaseFunctions.getPackageDownloadURLPlain
import com.pulumi.azurenative.testbase.TestbaseFunctions.getPackagePlain
import com.pulumi.azurenative.testbase.TestbaseFunctions.getTestBaseAccountFileUploadUrlPlain
import com.pulumi.azurenative.testbase.TestbaseFunctions.getTestBaseAccountPlain
import com.pulumi.azurenative.testbase.TestbaseFunctions.getTestResultConsoleLogDownloadURLPlain
import com.pulumi.azurenative.testbase.TestbaseFunctions.getTestResultDownloadURLPlain
import com.pulumi.azurenative.testbase.TestbaseFunctions.getTestResultVideoDownloadURLPlain
import com.pulumi.azurenative.testbase.kotlin.inputs.GetActionRequestPlainArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.GetActionRequestPlainArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.GetBillingHubServiceFreeHourBalancePlainArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.GetBillingHubServiceFreeHourBalancePlainArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.GetBillingHubServiceUsagePlainArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.GetBillingHubServiceUsagePlainArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.GetCredentialPlainArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.GetCredentialPlainArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.GetCustomImagePlainArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.GetCustomImagePlainArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.GetCustomerEventPlainArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.GetCustomerEventPlainArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.GetDraftPackagePathPlainArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.GetDraftPackagePathPlainArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.GetDraftPackagePlainArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.GetDraftPackagePlainArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.GetFavoriteProcessPlainArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.GetFavoriteProcessPlainArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.GetImageDefinitionPlainArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.GetImageDefinitionPlainArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.GetPackageDownloadURLPlainArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.GetPackageDownloadURLPlainArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.GetPackagePlainArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.GetPackagePlainArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.GetTestBaseAccountFileUploadUrlPlainArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.GetTestBaseAccountFileUploadUrlPlainArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.GetTestBaseAccountPlainArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.GetTestBaseAccountPlainArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.GetTestResultConsoleLogDownloadURLPlainArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.GetTestResultConsoleLogDownloadURLPlainArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.GetTestResultDownloadURLPlainArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.GetTestResultDownloadURLPlainArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.GetTestResultVideoDownloadURLPlainArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.GetTestResultVideoDownloadURLPlainArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.outputs.GetActionRequestResult
import com.pulumi.azurenative.testbase.kotlin.outputs.GetBillingHubServiceFreeHourBalanceResult
import com.pulumi.azurenative.testbase.kotlin.outputs.GetBillingHubServiceUsageResult
import com.pulumi.azurenative.testbase.kotlin.outputs.GetCredentialResult
import com.pulumi.azurenative.testbase.kotlin.outputs.GetCustomImageResult
import com.pulumi.azurenative.testbase.kotlin.outputs.GetCustomerEventResult
import com.pulumi.azurenative.testbase.kotlin.outputs.GetDraftPackagePathResult
import com.pulumi.azurenative.testbase.kotlin.outputs.GetDraftPackageResult
import com.pulumi.azurenative.testbase.kotlin.outputs.GetFavoriteProcessResult
import com.pulumi.azurenative.testbase.kotlin.outputs.GetImageDefinitionResult
import com.pulumi.azurenative.testbase.kotlin.outputs.GetPackageDownloadURLResult
import com.pulumi.azurenative.testbase.kotlin.outputs.GetPackageResult
import com.pulumi.azurenative.testbase.kotlin.outputs.GetTestBaseAccountFileUploadUrlResult
import com.pulumi.azurenative.testbase.kotlin.outputs.GetTestBaseAccountResult
import com.pulumi.azurenative.testbase.kotlin.outputs.GetTestResultConsoleLogDownloadURLResult
import com.pulumi.azurenative.testbase.kotlin.outputs.GetTestResultDownloadURLResult
import com.pulumi.azurenative.testbase.kotlin.outputs.GetTestResultVideoDownloadURLResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.testbase.kotlin.outputs.GetActionRequestResult.Companion.toKotlin as getActionRequestResultToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.GetBillingHubServiceFreeHourBalanceResult.Companion.toKotlin as getBillingHubServiceFreeHourBalanceResultToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.GetBillingHubServiceUsageResult.Companion.toKotlin as getBillingHubServiceUsageResultToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.GetCredentialResult.Companion.toKotlin as getCredentialResultToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.GetCustomImageResult.Companion.toKotlin as getCustomImageResultToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.GetCustomerEventResult.Companion.toKotlin as getCustomerEventResultToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.GetDraftPackagePathResult.Companion.toKotlin as getDraftPackagePathResultToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.GetDraftPackageResult.Companion.toKotlin as getDraftPackageResultToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.GetFavoriteProcessResult.Companion.toKotlin as getFavoriteProcessResultToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.GetImageDefinitionResult.Companion.toKotlin as getImageDefinitionResultToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.GetPackageDownloadURLResult.Companion.toKotlin as getPackageDownloadURLResultToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.GetPackageResult.Companion.toKotlin as getPackageResultToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.GetTestBaseAccountFileUploadUrlResult.Companion.toKotlin as getTestBaseAccountFileUploadUrlResultToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.GetTestBaseAccountResult.Companion.toKotlin as getTestBaseAccountResultToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.GetTestResultConsoleLogDownloadURLResult.Companion.toKotlin as getTestResultConsoleLogDownloadURLResultToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.GetTestResultDownloadURLResult.Companion.toKotlin as getTestResultDownloadURLResultToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.GetTestResultVideoDownloadURLResult.Companion.toKotlin as getTestResultVideoDownloadURLResultToKotlin

public object TestbaseFunctions {
    /**
     * Get the action request under the specified test base account.
     * Azure REST API version: 2023-11-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getActionRequest(argument: GetActionRequestPlainArgs): GetActionRequestResult =
        getActionRequestResultToKotlin(getActionRequestPlain(argument.toJava()).await())

    /**
     * @see [getActionRequest].
     * @param actionRequestName
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param testBaseAccountName The resource name of the Test Base Account.
     * @return null
     */
    public suspend fun getActionRequest(
        actionRequestName: String,
        resourceGroupName: String,
        testBaseAccountName: String,
    ): GetActionRequestResult {
        val argument = GetActionRequestPlainArgs(
            actionRequestName = actionRequestName,
            resourceGroupName = resourceGroupName,
            testBaseAccountName = testBaseAccountName,
        )
        return getActionRequestResultToKotlin(getActionRequestPlain(argument.toJava()).await())
    }

    /**
     * @see [getActionRequest].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;testbase&#46;kotlin&#46;inputs&#46;GetActionRequestPlainArgs].
     * @return null
     */
    public suspend fun getActionRequest(argument: suspend GetActionRequestPlainArgsBuilder.() -> Unit): GetActionRequestResult {
        val builder = GetActionRequestPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getActionRequestResultToKotlin(getActionRequestPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2022-04-01-preview.
     * Other available API versions: 2023-11-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getBillingHubServiceFreeHourBalance(argument: GetBillingHubServiceFreeHourBalancePlainArgs): GetBillingHubServiceFreeHourBalanceResult =
        getBillingHubServiceFreeHourBalanceResultToKotlin(getBillingHubServiceFreeHourBalancePlain(argument.toJava()).await())

    /**
     * @see [getBillingHubServiceFreeHourBalance].
     * @param resourceGroupName The name of the resource group that contains the resource.
     * @param testBaseAccountName The resource name of the Test Base Account.
     * @return null
     */
    public suspend fun getBillingHubServiceFreeHourBalance(
        resourceGroupName: String,
        testBaseAccountName: String,
    ): GetBillingHubServiceFreeHourBalanceResult {
        val argument = GetBillingHubServiceFreeHourBalancePlainArgs(
            resourceGroupName = resourceGroupName,
            testBaseAccountName = testBaseAccountName,
        )
        return getBillingHubServiceFreeHourBalanceResultToKotlin(getBillingHubServiceFreeHourBalancePlain(argument.toJava()).await())
    }

    /**
     * @see [getBillingHubServiceFreeHourBalance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;testbase&#46;kotlin&#46;inputs&#46;GetBillingHubServiceFreeHourBalancePlainArgs].
     * @return null
     */
    public suspend fun getBillingHubServiceFreeHourBalance(argument: suspend GetBillingHubServiceFreeHourBalancePlainArgsBuilder.() -> Unit): GetBillingHubServiceFreeHourBalanceResult {
        val builder = GetBillingHubServiceFreeHourBalancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBillingHubServiceFreeHourBalanceResultToKotlin(getBillingHubServiceFreeHourBalancePlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2022-04-01-preview.
     * Other available API versions: 2023-11-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getBillingHubServiceUsage(argument: GetBillingHubServiceUsagePlainArgs): GetBillingHubServiceUsageResult =
        getBillingHubServiceUsageResultToKotlin(getBillingHubServiceUsagePlain(argument.toJava()).await())

    /**
     * @see [getBillingHubServiceUsage].
     * @param endTimeStamp
     * @param pageIndex
     * @param pageSize
     * @param resourceGroupName The name of the resource group that contains the resource.
     * @param startTimeStamp
     * @param testBaseAccountName The resource name of the Test Base Account.
     * @return null
     */
    public suspend fun getBillingHubServiceUsage(
        endTimeStamp: String,
        pageIndex: Int? = null,
        pageSize: Int? = null,
        resourceGroupName: String,
        startTimeStamp: String,
        testBaseAccountName: String,
    ): GetBillingHubServiceUsageResult {
        val argument = GetBillingHubServiceUsagePlainArgs(
            endTimeStamp = endTimeStamp,
            pageIndex = pageIndex,
            pageSize = pageSize,
            resourceGroupName = resourceGroupName,
            startTimeStamp = startTimeStamp,
            testBaseAccountName = testBaseAccountName,
        )
        return getBillingHubServiceUsageResultToKotlin(getBillingHubServiceUsagePlain(argument.toJava()).await())
    }

    /**
     * @see [getBillingHubServiceUsage].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;testbase&#46;kotlin&#46;inputs&#46;GetBillingHubServiceUsagePlainArgs].
     * @return null
     */
    public suspend fun getBillingHubServiceUsage(argument: suspend GetBillingHubServiceUsagePlainArgsBuilder.() -> Unit): GetBillingHubServiceUsageResult {
        val builder = GetBillingHubServiceUsagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBillingHubServiceUsageResultToKotlin(getBillingHubServiceUsagePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a test base credential Resource
     * Azure REST API version: 2023-11-01-preview.
     * @param argument null
     * @return The test base credential resource.
     */
    public suspend fun getCredential(argument: GetCredentialPlainArgs): GetCredentialResult =
        getCredentialResultToKotlin(getCredentialPlain(argument.toJava()).await())

    /**
     * @see [getCredential].
     * @param credentialName The credential resource name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param testBaseAccountName The resource name of the Test Base Account.
     * @return The test base credential resource.
     */
    public suspend fun getCredential(
        credentialName: String,
        resourceGroupName: String,
        testBaseAccountName: String,
    ): GetCredentialResult {
        val argument = GetCredentialPlainArgs(
            credentialName = credentialName,
            resourceGroupName = resourceGroupName,
            testBaseAccountName = testBaseAccountName,
        )
        return getCredentialResultToKotlin(getCredentialPlain(argument.toJava()).await())
    }

    /**
     * @see [getCredential].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;testbase&#46;kotlin&#46;inputs&#46;GetCredentialPlainArgs].
     * @return The test base credential resource.
     */
    public suspend fun getCredential(argument: suspend GetCredentialPlainArgsBuilder.() -> Unit): GetCredentialResult {
        val builder = GetCredentialPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCredentialResultToKotlin(getCredentialPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a test base custom image.
     * Azure REST API version: 2023-11-01-preview.
     * @param argument null
     * @return The test base custom image resource.
     */
    public suspend fun getCustomImage(argument: GetCustomImagePlainArgs): GetCustomImageResult =
        getCustomImageResultToKotlin(getCustomImagePlain(argument.toJava()).await())

    /**
     * @see [getCustomImage].
     * @param customImageName The resource name of the test base custom image.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param testBaseAccountName The resource name of the Test Base Account.
     * @return The test base custom image resource.
     */
    public suspend fun getCustomImage(
        customImageName: String,
        resourceGroupName: String,
        testBaseAccountName: String,
    ): GetCustomImageResult {
        val argument = GetCustomImagePlainArgs(
            customImageName = customImageName,
            resourceGroupName = resourceGroupName,
            testBaseAccountName = testBaseAccountName,
        )
        return getCustomImageResultToKotlin(getCustomImagePlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomImage].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;testbase&#46;kotlin&#46;inputs&#46;GetCustomImagePlainArgs].
     * @return The test base custom image resource.
     */
    public suspend fun getCustomImage(argument: suspend GetCustomImagePlainArgsBuilder.() -> Unit): GetCustomImageResult {
        val builder = GetCustomImagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomImageResultToKotlin(getCustomImagePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Test Base CustomerEvent.
     * Azure REST API version: 2022-04-01-preview.
     * Other available API versions: 2023-11-01-preview.
     * @param argument null
     * @return The Customer Notification Event resource.
     */
    public suspend fun getCustomerEvent(argument: GetCustomerEventPlainArgs): GetCustomerEventResult =
        getCustomerEventResultToKotlin(getCustomerEventPlain(argument.toJava()).await())

    /**
     * @see [getCustomerEvent].
     * @param customerEventName The resource name of the Test Base Customer event.
     * @param resourceGroupName The name of the resource group that contains the resource.
     * @param testBaseAccountName The resource name of the Test Base Account.
     * @return The Customer Notification Event resource.
     */
    public suspend fun getCustomerEvent(
        customerEventName: String,
        resourceGroupName: String,
        testBaseAccountName: String,
    ): GetCustomerEventResult {
        val argument = GetCustomerEventPlainArgs(
            customerEventName = customerEventName,
            resourceGroupName = resourceGroupName,
            testBaseAccountName = testBaseAccountName,
        )
        return getCustomerEventResultToKotlin(getCustomerEventPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomerEvent].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;testbase&#46;kotlin&#46;inputs&#46;GetCustomerEventPlainArgs].
     * @return The Customer Notification Event resource.
     */
    public suspend fun getCustomerEvent(argument: suspend GetCustomerEventPlainArgsBuilder.() -> Unit): GetCustomerEventResult {
        val builder = GetCustomerEventPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomerEventResultToKotlin(getCustomerEventPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Test Base Draft Package.
     * Azure REST API version: 2023-11-01-preview.
     * @param argument null
     * @return The Test Base Draft Package resource.
     */
    public suspend fun getDraftPackage(argument: GetDraftPackagePlainArgs): GetDraftPackageResult =
        getDraftPackageResultToKotlin(getDraftPackagePlain(argument.toJava()).await())

    /**
     * @see [getDraftPackage].
     * @param draftPackageName The resource name of the Test Base Draft Package.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param testBaseAccountName The resource name of the Test Base Account.
     * @return The Test Base Draft Package resource.
     */
    public suspend fun getDraftPackage(
        draftPackageName: String,
        resourceGroupName: String,
        testBaseAccountName: String,
    ): GetDraftPackageResult {
        val argument = GetDraftPackagePlainArgs(
            draftPackageName = draftPackageName,
            resourceGroupName = resourceGroupName,
            testBaseAccountName = testBaseAccountName,
        )
        return getDraftPackageResultToKotlin(getDraftPackagePlain(argument.toJava()).await())
    }

    /**
     * @see [getDraftPackage].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;testbase&#46;kotlin&#46;inputs&#46;GetDraftPackagePlainArgs].
     * @return The Test Base Draft Package resource.
     */
    public suspend fun getDraftPackage(argument: suspend GetDraftPackagePlainArgsBuilder.() -> Unit): GetDraftPackageResult {
        val builder = GetDraftPackagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDraftPackageResultToKotlin(getDraftPackagePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets draft package path and temp working path with SAS.
     * Azure REST API version: 2023-11-01-preview.
     * @param argument null
     * @return The response of getting a download URL.
     */
    public suspend fun getDraftPackagePath(argument: GetDraftPackagePathPlainArgs): GetDraftPackagePathResult =
        getDraftPackagePathResultToKotlin(getDraftPackagePathPlain(argument.toJava()).await())

    /**
     * @see [getDraftPackagePath].
     * @param draftPackageName The resource name of the Test Base Draft Package.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param testBaseAccountName The resource name of the Test Base Account.
     * @return The response of getting a download URL.
     */
    public suspend fun getDraftPackagePath(
        draftPackageName: String,
        resourceGroupName: String,
        testBaseAccountName: String,
    ): GetDraftPackagePathResult {
        val argument = GetDraftPackagePathPlainArgs(
            draftPackageName = draftPackageName,
            resourceGroupName = resourceGroupName,
            testBaseAccountName = testBaseAccountName,
        )
        return getDraftPackagePathResultToKotlin(getDraftPackagePathPlain(argument.toJava()).await())
    }

    /**
     * @see [getDraftPackagePath].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;testbase&#46;kotlin&#46;inputs&#46;GetDraftPackagePathPlainArgs].
     * @return The response of getting a download URL.
     */
    public suspend fun getDraftPackagePath(argument: suspend GetDraftPackagePathPlainArgsBuilder.() -> Unit): GetDraftPackagePathResult {
        val builder = GetDraftPackagePathPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDraftPackagePathResultToKotlin(getDraftPackagePathPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a favorite process for a Test Base Package.
     * Azure REST API version: 2022-04-01-preview.
     * Other available API versions: 2023-11-01-preview.
     * @param argument null
     * @return A favorite process identifier.
     */
    public suspend fun getFavoriteProcess(argument: GetFavoriteProcessPlainArgs): GetFavoriteProcessResult =
        getFavoriteProcessResultToKotlin(getFavoriteProcessPlain(argument.toJava()).await())

    /**
     * @see [getFavoriteProcess].
     * @param favoriteProcessResourceName The resource name of a favorite process in a package. If the process name contains characters that are not allowed in Azure Resource Name, we use 'actualProcessName' in request body to submit the name.
     * @param packageName The resource name of the Test Base Package.
     * @param resourceGroupName The name of the resource group that contains the resource.
     * @param testBaseAccountName The resource name of the Test Base Account.
     * @return A favorite process identifier.
     */
    public suspend fun getFavoriteProcess(
        favoriteProcessResourceName: String,
        packageName: String,
        resourceGroupName: String,
        testBaseAccountName: String,
    ): GetFavoriteProcessResult {
        val argument = GetFavoriteProcessPlainArgs(
            favoriteProcessResourceName = favoriteProcessResourceName,
            packageName = packageName,
            resourceGroupName = resourceGroupName,
            testBaseAccountName = testBaseAccountName,
        )
        return getFavoriteProcessResultToKotlin(getFavoriteProcessPlain(argument.toJava()).await())
    }

    /**
     * @see [getFavoriteProcess].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;testbase&#46;kotlin&#46;inputs&#46;GetFavoriteProcessPlainArgs].
     * @return A favorite process identifier.
     */
    public suspend fun getFavoriteProcess(argument: suspend GetFavoriteProcessPlainArgsBuilder.() -> Unit): GetFavoriteProcessResult {
        val builder = GetFavoriteProcessPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFavoriteProcessResultToKotlin(getFavoriteProcessPlain(builtArgument.toJava()).await())
    }

    /**
     * Get image properties under the image definition name created by test base custom image which derived from 'VHD' source.
     * Azure REST API version: 2023-11-01-preview.
     * @param argument null
     * @return The test base image definition resource.
     */
    public suspend fun getImageDefinition(argument: GetImageDefinitionPlainArgs): GetImageDefinitionResult =
        getImageDefinitionResultToKotlin(getImageDefinitionPlain(argument.toJava()).await())

    /**
     * @see [getImageDefinition].
     * @param imageDefinitionName The resource name of the test base image definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param testBaseAccountName The resource name of the Test Base Account.
     * @return The test base image definition resource.
     */
    public suspend fun getImageDefinition(
        imageDefinitionName: String,
        resourceGroupName: String,
        testBaseAccountName: String,
    ): GetImageDefinitionResult {
        val argument = GetImageDefinitionPlainArgs(
            imageDefinitionName = imageDefinitionName,
            resourceGroupName = resourceGroupName,
            testBaseAccountName = testBaseAccountName,
        )
        return getImageDefinitionResultToKotlin(getImageDefinitionPlain(argument.toJava()).await())
    }

    /**
     * @see [getImageDefinition].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;testbase&#46;kotlin&#46;inputs&#46;GetImageDefinitionPlainArgs].
     * @return The test base image definition resource.
     */
    public suspend fun getImageDefinition(argument: suspend GetImageDefinitionPlainArgsBuilder.() -> Unit): GetImageDefinitionResult {
        val builder = GetImageDefinitionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getImageDefinitionResultToKotlin(getImageDefinitionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Test Base Package.
     * Azure REST API version: 2022-04-01-preview.
     * Other available API versions: 2023-11-01-preview.
     * @param argument null
     * @return The Test Base Package resource.
     */
    public suspend fun getPackage(argument: GetPackagePlainArgs): GetPackageResult =
        getPackageResultToKotlin(getPackagePlain(argument.toJava()).await())

    /**
     * @see [getPackage].
     * @param packageName The resource name of the Test Base Package.
     * @param resourceGroupName The name of the resource group that contains the resource.
     * @param testBaseAccountName The resource name of the Test Base Account.
     * @return The Test Base Package resource.
     */
    public suspend fun getPackage(
        packageName: String,
        resourceGroupName: String,
        testBaseAccountName: String,
    ): GetPackageResult {
        val argument = GetPackagePlainArgs(
            packageName = packageName,
            resourceGroupName = resourceGroupName,
            testBaseAccountName = testBaseAccountName,
        )
        return getPackageResultToKotlin(getPackagePlain(argument.toJava()).await())
    }

    /**
     * @see [getPackage].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;testbase&#46;kotlin&#46;inputs&#46;GetPackagePlainArgs].
     * @return The Test Base Package resource.
     */
    public suspend fun getPackage(argument: suspend GetPackagePlainArgsBuilder.() -> Unit): GetPackageResult {
        val builder = GetPackagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPackageResultToKotlin(getPackagePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the download URL of a package.
     * Azure REST API version: 2022-04-01-preview.
     * Other available API versions: 2023-11-01-preview.
     * @param argument null
     * @return The response of getting a download URL.
     */
    public suspend fun getPackageDownloadURL(argument: GetPackageDownloadURLPlainArgs): GetPackageDownloadURLResult =
        getPackageDownloadURLResultToKotlin(getPackageDownloadURLPlain(argument.toJava()).await())

    /**
     * @see [getPackageDownloadURL].
     * @param packageName The resource name of the Test Base Package.
     * @param resourceGroupName The name of the resource group that contains the resource.
     * @param testBaseAccountName The resource name of the Test Base Account.
     * @return The response of getting a download URL.
     */
    public suspend fun getPackageDownloadURL(
        packageName: String,
        resourceGroupName: String,
        testBaseAccountName: String,
    ): GetPackageDownloadURLResult {
        val argument = GetPackageDownloadURLPlainArgs(
            packageName = packageName,
            resourceGroupName = resourceGroupName,
            testBaseAccountName = testBaseAccountName,
        )
        return getPackageDownloadURLResultToKotlin(getPackageDownloadURLPlain(argument.toJava()).await())
    }

    /**
     * @see [getPackageDownloadURL].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;testbase&#46;kotlin&#46;inputs&#46;GetPackageDownloadURLPlainArgs].
     * @return The response of getting a download URL.
     */
    public suspend fun getPackageDownloadURL(argument: suspend GetPackageDownloadURLPlainArgsBuilder.() -> Unit): GetPackageDownloadURLResult {
        val builder = GetPackageDownloadURLPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPackageDownloadURLResultToKotlin(getPackageDownloadURLPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Test Base Account.
     * Azure REST API version: 2022-04-01-preview.
     * Other available API versions: 2023-11-01-preview.
     * @param argument null
     * @return The Test Base Account resource.
     */
    public suspend fun getTestBaseAccount(argument: GetTestBaseAccountPlainArgs): GetTestBaseAccountResult =
        getTestBaseAccountResultToKotlin(getTestBaseAccountPlain(argument.toJava()).await())

    /**
     * @see [getTestBaseAccount].
     * @param resourceGroupName The name of the resource group that contains the resource.
     * @param testBaseAccountName The resource name of the Test Base Account.
     * @return The Test Base Account resource.
     */
    public suspend fun getTestBaseAccount(resourceGroupName: String, testBaseAccountName: String): GetTestBaseAccountResult {
        val argument = GetTestBaseAccountPlainArgs(
            resourceGroupName = resourceGroupName,
            testBaseAccountName = testBaseAccountName,
        )
        return getTestBaseAccountResultToKotlin(getTestBaseAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getTestBaseAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;testbase&#46;kotlin&#46;inputs&#46;GetTestBaseAccountPlainArgs].
     * @return The Test Base Account resource.
     */
    public suspend fun getTestBaseAccount(argument: suspend GetTestBaseAccountPlainArgsBuilder.() -> Unit): GetTestBaseAccountResult {
        val builder = GetTestBaseAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTestBaseAccountResultToKotlin(getTestBaseAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the file upload URL of a Test Base Account.
     * Azure REST API version: 2022-04-01-preview.
     * Other available API versions: 2023-11-01-preview.
     * @param argument null
     * @return The URL response
     */
    public suspend fun getTestBaseAccountFileUploadUrl(argument: GetTestBaseAccountFileUploadUrlPlainArgs): GetTestBaseAccountFileUploadUrlResult =
        getTestBaseAccountFileUploadUrlResultToKotlin(getTestBaseAccountFileUploadUrlPlain(argument.toJava()).await())

    /**
     * @see [getTestBaseAccountFileUploadUrl].
     * @param blobName The custom file name of the uploaded blob.
     * @param resourceGroupName The name of the resource group that contains the resource.
     * @param testBaseAccountName The resource name of the Test Base Account.
     * @return The URL response
     */
    public suspend fun getTestBaseAccountFileUploadUrl(
        blobName: String? = null,
        resourceGroupName: String,
        testBaseAccountName: String,
    ): GetTestBaseAccountFileUploadUrlResult {
        val argument = GetTestBaseAccountFileUploadUrlPlainArgs(
            blobName = blobName,
            resourceGroupName = resourceGroupName,
            testBaseAccountName = testBaseAccountName,
        )
        return getTestBaseAccountFileUploadUrlResultToKotlin(getTestBaseAccountFileUploadUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [getTestBaseAccountFileUploadUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;testbase&#46;kotlin&#46;inputs&#46;GetTestBaseAccountFileUploadUrlPlainArgs].
     * @return The URL response
     */
    public suspend fun getTestBaseAccountFileUploadUrl(argument: suspend GetTestBaseAccountFileUploadUrlPlainArgsBuilder.() -> Unit): GetTestBaseAccountFileUploadUrlResult {
        val builder = GetTestBaseAccountFileUploadUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTestBaseAccountFileUploadUrlResultToKotlin(getTestBaseAccountFileUploadUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the download URL of the test execution console log file.
     * Azure REST API version: 2022-04-01-preview.
     * Other available API versions: 2023-11-01-preview.
     * @param argument null
     * @return The response of getting a download URL.
     */
    public suspend fun getTestResultConsoleLogDownloadURL(argument: GetTestResultConsoleLogDownloadURLPlainArgs): GetTestResultConsoleLogDownloadURLResult =
        getTestResultConsoleLogDownloadURLResultToKotlin(getTestResultConsoleLogDownloadURLPlain(argument.toJava()).await())

    /**
     * @see [getTestResultConsoleLogDownloadURL].
     * @param logFileName The log file name corresponding to the download URL.
     * @param packageName The resource name of the Test Base Package.
     * @param resourceGroupName The name of the resource group that contains the resource.
     * @param testBaseAccountName The resource name of the Test Base Account.
     * @param testResultName The Test Result Name. It equals to TestResult-{TestResultId} string.
     * @return The response of getting a download URL.
     */
    public suspend fun getTestResultConsoleLogDownloadURL(
        logFileName: String,
        packageName: String,
        resourceGroupName: String,
        testBaseAccountName: String,
        testResultName: String,
    ): GetTestResultConsoleLogDownloadURLResult {
        val argument = GetTestResultConsoleLogDownloadURLPlainArgs(
            logFileName = logFileName,
            packageName = packageName,
            resourceGroupName = resourceGroupName,
            testBaseAccountName = testBaseAccountName,
            testResultName = testResultName,
        )
        return getTestResultConsoleLogDownloadURLResultToKotlin(getTestResultConsoleLogDownloadURLPlain(argument.toJava()).await())
    }

    /**
     * @see [getTestResultConsoleLogDownloadURL].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;testbase&#46;kotlin&#46;inputs&#46;GetTestResultConsoleLogDownloadURLPlainArgs].
     * @return The response of getting a download URL.
     */
    public suspend fun getTestResultConsoleLogDownloadURL(argument: suspend GetTestResultConsoleLogDownloadURLPlainArgsBuilder.() -> Unit): GetTestResultConsoleLogDownloadURLResult {
        val builder = GetTestResultConsoleLogDownloadURLPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTestResultConsoleLogDownloadURLResultToKotlin(getTestResultConsoleLogDownloadURLPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the download URL of the test result.
     * Azure REST API version: 2022-04-01-preview.
     * Other available API versions: 2023-11-01-preview.
     * @param argument null
     * @return The response of getting a download URL.
     */
    public suspend fun getTestResultDownloadURL(argument: GetTestResultDownloadURLPlainArgs): GetTestResultDownloadURLResult =
        getTestResultDownloadURLResultToKotlin(getTestResultDownloadURLPlain(argument.toJava()).await())

    /**
     * @see [getTestResultDownloadURL].
     * @param packageName The resource name of the Test Base Package.
     * @param resourceGroupName The name of the resource group that contains the resource.
     * @param testBaseAccountName The resource name of the Test Base Account.
     * @param testResultName The Test Result Name. It equals to TestResult-{TestResultId} string.
     * @return The response of getting a download URL.
     */
    public suspend fun getTestResultDownloadURL(
        packageName: String,
        resourceGroupName: String,
        testBaseAccountName: String,
        testResultName: String,
    ): GetTestResultDownloadURLResult {
        val argument = GetTestResultDownloadURLPlainArgs(
            packageName = packageName,
            resourceGroupName = resourceGroupName,
            testBaseAccountName = testBaseAccountName,
            testResultName = testResultName,
        )
        return getTestResultDownloadURLResultToKotlin(getTestResultDownloadURLPlain(argument.toJava()).await())
    }

    /**
     * @see [getTestResultDownloadURL].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;testbase&#46;kotlin&#46;inputs&#46;GetTestResultDownloadURLPlainArgs].
     * @return The response of getting a download URL.
     */
    public suspend fun getTestResultDownloadURL(argument: suspend GetTestResultDownloadURLPlainArgsBuilder.() -> Unit): GetTestResultDownloadURLResult {
        val builder = GetTestResultDownloadURLPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTestResultDownloadURLResultToKotlin(getTestResultDownloadURLPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the download URL of the test execution screen recording.
     * Azure REST API version: 2022-04-01-preview.
     * Other available API versions: 2023-11-01-preview.
     * @param argument null
     * @return The response of getting a download URL.
     */
    public suspend fun getTestResultVideoDownloadURL(argument: GetTestResultVideoDownloadURLPlainArgs): GetTestResultVideoDownloadURLResult =
        getTestResultVideoDownloadURLResultToKotlin(getTestResultVideoDownloadURLPlain(argument.toJava()).await())

    /**
     * @see [getTestResultVideoDownloadURL].
     * @param packageName The resource name of the Test Base Package.
     * @param resourceGroupName The name of the resource group that contains the resource.
     * @param testBaseAccountName The resource name of the Test Base Account.
     * @param testResultName The Test Result Name. It equals to TestResult-{TestResultId} string.
     * @return The response of getting a download URL.
     */
    public suspend fun getTestResultVideoDownloadURL(
        packageName: String,
        resourceGroupName: String,
        testBaseAccountName: String,
        testResultName: String,
    ): GetTestResultVideoDownloadURLResult {
        val argument = GetTestResultVideoDownloadURLPlainArgs(
            packageName = packageName,
            resourceGroupName = resourceGroupName,
            testBaseAccountName = testBaseAccountName,
            testResultName = testResultName,
        )
        return getTestResultVideoDownloadURLResultToKotlin(getTestResultVideoDownloadURLPlain(argument.toJava()).await())
    }

    /**
     * @see [getTestResultVideoDownloadURL].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;testbase&#46;kotlin&#46;inputs&#46;GetTestResultVideoDownloadURLPlainArgs].
     * @return The response of getting a download URL.
     */
    public suspend fun getTestResultVideoDownloadURL(argument: suspend GetTestResultVideoDownloadURLPlainArgsBuilder.() -> Unit): GetTestResultVideoDownloadURLResult {
        val builder = GetTestResultVideoDownloadURLPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTestResultVideoDownloadURLResultToKotlin(getTestResultVideoDownloadURLPlain(builtArgument.toJava()).await())
    }
}
