@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The architecture of a first party application of a Test Base Account.
 */
public enum class Architecture(
    public val javaValue: com.pulumi.azurenative.testbase.enums.Architecture,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.enums.Architecture> {
    X86(com.pulumi.azurenative.testbase.enums.Architecture.X86),
    X64(com.pulumi.azurenative.testbase.enums.Architecture.X64),
    Arm64(com.pulumi.azurenative.testbase.enums.Architecture.Arm64),
    ;

    override fun toJava(): com.pulumi.azurenative.testbase.enums.Architecture = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.enums.Architecture): Architecture = Architecture.values().first { it.javaValue == javaType }
    }
}
