@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Custom image security type.
 */
public enum class ImageSecurityType(
    public val javaValue: com.pulumi.azurenative.testbase.enums.ImageSecurityType,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.enums.ImageSecurityType> {
    /**
     * Standard security type.
     */
    Standard(com.pulumi.azurenative.testbase.enums.ImageSecurityType.Standard),

    /**
     * Specify higher security level compared to Standard.
     */
    TrustedLaunch(com.pulumi.azurenative.testbase.enums.ImageSecurityType.TrustedLaunch),
    ;

    override fun toJava(): com.pulumi.azurenative.testbase.enums.ImageSecurityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.enums.ImageSecurityType): ImageSecurityType = ImageSecurityType.values().first { it.javaValue == javaType }
    }
}
