@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies how the first party applications should be inter-operated with user's application.
 */
public enum class InteropExecutionMode(
    public val javaValue: com.pulumi.azurenative.testbase.enums.InteropExecutionMode,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.enums.InteropExecutionMode> {
    /**
     * User application will test with the first party applications. For out-of-box tests, additional test cases for first party applications will also be run.
     */
    FirstPartyAppWithTests(com.pulumi.azurenative.testbase.enums.InteropExecutionMode.FirstPartyAppWithTests),

    /**
     * User application will test with the first party applications.
     */
    FirstPartyApp(com.pulumi.azurenative.testbase.enums.InteropExecutionMode.FirstPartyApp),
    ;

    override fun toJava(): com.pulumi.azurenative.testbase.enums.InteropExecutionMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.enums.InteropExecutionMode): InteropExecutionMode = InteropExecutionMode.values().first { it.javaValue == javaType }
    }
}
