@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.DistributionGroupListReceiverValueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The user object receiver value.
 * @property distributionGroups The list of distribution groups.
 */
public data class DistributionGroupListReceiverValueArgs(
    public val distributionGroups: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.DistributionGroupListReceiverValueArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.DistributionGroupListReceiverValueArgs =
        com.pulumi.azurenative.testbase.inputs.DistributionGroupListReceiverValueArgs.builder()
            .distributionGroups(
                distributionGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [DistributionGroupListReceiverValueArgs].
 */
@PulumiTagMarker
public class DistributionGroupListReceiverValueArgsBuilder internal constructor() {
    private var distributionGroups: Output<List<String>>? = null

    /**
     * @param value The list of distribution groups.
     */
    @JvmName("whcvqnknkhvsfvoa")
    public suspend fun distributionGroups(`value`: Output<List<String>>) {
        this.distributionGroups = value
    }

    @JvmName("mjuolstxakxlmeyi")
    public suspend fun distributionGroups(vararg values: Output<String>) {
        this.distributionGroups = Output.all(values.asList())
    }

    /**
     * @param values The list of distribution groups.
     */
    @JvmName("yulpqletsssokxvy")
    public suspend fun distributionGroups(values: List<Output<String>>) {
        this.distributionGroups = Output.all(values)
    }

    /**
     * @param value The list of distribution groups.
     */
    @JvmName("jutsupbgphsbejlo")
    public suspend fun distributionGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distributionGroups = mapped
    }

    /**
     * @param values The list of distribution groups.
     */
    @JvmName("lenjmxerbgjpvwnn")
    public suspend fun distributionGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.distributionGroups = mapped
    }

    internal fun build(): DistributionGroupListReceiverValueArgs =
        DistributionGroupListReceiverValueArgs(
            distributionGroups = distributionGroups,
        )
}
