@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.DraftPackageIntuneAppMetadataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The metadata of Intune app(s) used for generation.
 * @property intuneApp The Metadata of the Intune App through intunewin file uploading.
 * @property intuneAppDependencies The Metadata of dependencies of the Intune App through intunewin file uploading.
 */
public data class DraftPackageIntuneAppMetadataArgs(
    public val intuneApp: Output<DraftPackageIntuneAppMetadataItemArgs>? = null,
    public val intuneAppDependencies: Output<List<DraftPackageIntuneAppMetadataItemArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.DraftPackageIntuneAppMetadataArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.DraftPackageIntuneAppMetadataArgs =
        com.pulumi.azurenative.testbase.inputs.DraftPackageIntuneAppMetadataArgs.builder()
            .intuneApp(intuneApp?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .intuneAppDependencies(
                intuneAppDependencies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DraftPackageIntuneAppMetadataArgs].
 */
@PulumiTagMarker
public class DraftPackageIntuneAppMetadataArgsBuilder internal constructor() {
    private var intuneApp: Output<DraftPackageIntuneAppMetadataItemArgs>? = null

    private var intuneAppDependencies: Output<List<DraftPackageIntuneAppMetadataItemArgs>>? = null

    /**
     * @param value The Metadata of the Intune App through intunewin file uploading.
     */
    @JvmName("tpiqpcvorkwggpjp")
    public suspend fun intuneApp(`value`: Output<DraftPackageIntuneAppMetadataItemArgs>) {
        this.intuneApp = value
    }

    /**
     * @param value The Metadata of dependencies of the Intune App through intunewin file uploading.
     */
    @JvmName("vdtwfqjxvdfpwtsq")
    public suspend fun intuneAppDependencies(`value`: Output<List<DraftPackageIntuneAppMetadataItemArgs>>) {
        this.intuneAppDependencies = value
    }

    @JvmName("ggbjtdmohvplnrod")
    public suspend fun intuneAppDependencies(vararg values: Output<DraftPackageIntuneAppMetadataItemArgs>) {
        this.intuneAppDependencies = Output.all(values.asList())
    }

    /**
     * @param values The Metadata of dependencies of the Intune App through intunewin file uploading.
     */
    @JvmName("yxyjairglmcybxuw")
    public suspend fun intuneAppDependencies(values: List<Output<DraftPackageIntuneAppMetadataItemArgs>>) {
        this.intuneAppDependencies = Output.all(values)
    }

    /**
     * @param value The Metadata of the Intune App through intunewin file uploading.
     */
    @JvmName("ycqvlngymgynnowv")
    public suspend fun intuneApp(`value`: DraftPackageIntuneAppMetadataItemArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intuneApp = mapped
    }

    /**
     * @param argument The Metadata of the Intune App through intunewin file uploading.
     */
    @JvmName("hnxfpvutvvlxttfp")
    public suspend fun intuneApp(argument: suspend DraftPackageIntuneAppMetadataItemArgsBuilder.() -> Unit) {
        val toBeMapped = DraftPackageIntuneAppMetadataItemArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.intuneApp = mapped
    }

    /**
     * @param value The Metadata of dependencies of the Intune App through intunewin file uploading.
     */
    @JvmName("nusqbfcwdrcrxqpv")
    public suspend fun intuneAppDependencies(`value`: List<DraftPackageIntuneAppMetadataItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intuneAppDependencies = mapped
    }

    /**
     * @param argument The Metadata of dependencies of the Intune App through intunewin file uploading.
     */
    @JvmName("tsjowklypvohlykj")
    public suspend fun intuneAppDependencies(argument: List<suspend DraftPackageIntuneAppMetadataItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DraftPackageIntuneAppMetadataItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.intuneAppDependencies = mapped
    }

    /**
     * @param argument The Metadata of dependencies of the Intune App through intunewin file uploading.
     */
    @JvmName("trglqqrdempkyosr")
    public suspend fun intuneAppDependencies(vararg argument: suspend DraftPackageIntuneAppMetadataItemArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DraftPackageIntuneAppMetadataItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.intuneAppDependencies = mapped
    }

    /**
     * @param argument The Metadata of dependencies of the Intune App through intunewin file uploading.
     */
    @JvmName("mcncvvfofqmlebrs")
    public suspend fun intuneAppDependencies(argument: suspend DraftPackageIntuneAppMetadataItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DraftPackageIntuneAppMetadataItemArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.intuneAppDependencies = mapped
    }

    /**
     * @param values The Metadata of dependencies of the Intune App through intunewin file uploading.
     */
    @JvmName("eyfghvbfrxovkfva")
    public suspend fun intuneAppDependencies(vararg values: DraftPackageIntuneAppMetadataItemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.intuneAppDependencies = mapped
    }

    internal fun build(): DraftPackageIntuneAppMetadataArgs = DraftPackageIntuneAppMetadataArgs(
        intuneApp = intuneApp,
        intuneAppDependencies = intuneAppDependencies,
    )
}
