@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.EnrolledIntuneAppArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Metadata of the enrolled Intune app.
 * @property appId Intune app id.
 * @property appName Intune app name.
 * @property expectedInstallationPath Intune app expected installation path.
 */
public data class EnrolledIntuneAppArgs(
    public val appId: Output<String>,
    public val appName: Output<String>,
    public val expectedInstallationPath: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.EnrolledIntuneAppArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.EnrolledIntuneAppArgs =
        com.pulumi.azurenative.testbase.inputs.EnrolledIntuneAppArgs.builder()
            .appId(appId.applyValue({ args0 -> args0 }))
            .appName(appName.applyValue({ args0 -> args0 }))
            .expectedInstallationPath(expectedInstallationPath.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnrolledIntuneAppArgs].
 */
@PulumiTagMarker
public class EnrolledIntuneAppArgsBuilder internal constructor() {
    private var appId: Output<String>? = null

    private var appName: Output<String>? = null

    private var expectedInstallationPath: Output<String>? = null

    /**
     * @param value Intune app id.
     */
    @JvmName("mkwebqhjccsxgvin")
    public suspend fun appId(`value`: Output<String>) {
        this.appId = value
    }

    /**
     * @param value Intune app name.
     */
    @JvmName("ipedorkrsehedurw")
    public suspend fun appName(`value`: Output<String>) {
        this.appName = value
    }

    /**
     * @param value Intune app expected installation path.
     */
    @JvmName("rjimctekrlmkfrfx")
    public suspend fun expectedInstallationPath(`value`: Output<String>) {
        this.expectedInstallationPath = value
    }

    /**
     * @param value Intune app id.
     */
    @JvmName("locxdbpbqkxoysae")
    public suspend fun appId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appId = mapped
    }

    /**
     * @param value Intune app name.
     */
    @JvmName("wqmwbjogqucnkuuw")
    public suspend fun appName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appName = mapped
    }

    /**
     * @param value Intune app expected installation path.
     */
    @JvmName("fholqoetsirjoyqv")
    public suspend fun expectedInstallationPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expectedInstallationPath = mapped
    }

    internal fun build(): EnrolledIntuneAppArgs = EnrolledIntuneAppArgs(
        appId = appId ?: throw PulumiNullFieldException("appId"),
        appName = appName ?: throw PulumiNullFieldException("appName"),
        expectedInstallationPath = expectedInstallationPath ?: throw
            PulumiNullFieldException("expectedInstallationPath"),
    )
}
