@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.FirstPartyAppDefinitionArgs.builder
import com.pulumi.azurenative.testbase.kotlin.enums.Architecture
import com.pulumi.azurenative.testbase.kotlin.enums.InteropExecutionMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of the definition of a first party application of the Test Base package.
 * @property architecture The architecture of a first party application of a Test Base Account.
 * @property channel The channel info of a first party application of a Test Base Account.
 * @property interopExecutionMode Specifies how the first party applications should be inter-operated with user's application.
 * @property name The media name of a first party application of a Test Base Account.
 * @property ring The ring info of a first party application of a Test Base Account.
 */
public data class FirstPartyAppDefinitionArgs(
    public val architecture: Output<Either<String, Architecture>>? = null,
    public val channel: Output<String>? = null,
    public val interopExecutionMode: Output<Either<String, InteropExecutionMode>>? = null,
    public val name: Output<String>? = null,
    public val ring: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.FirstPartyAppDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.FirstPartyAppDefinitionArgs =
        com.pulumi.azurenative.testbase.inputs.FirstPartyAppDefinitionArgs.builder()
            .architecture(
                architecture?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .channel(channel?.applyValue({ args0 -> args0 }))
            .interopExecutionMode(
                interopExecutionMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .ring(ring?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirstPartyAppDefinitionArgs].
 */
@PulumiTagMarker
public class FirstPartyAppDefinitionArgsBuilder internal constructor() {
    private var architecture: Output<Either<String, Architecture>>? = null

    private var channel: Output<String>? = null

    private var interopExecutionMode: Output<Either<String, InteropExecutionMode>>? = null

    private var name: Output<String>? = null

    private var ring: Output<String>? = null

    /**
     * @param value The architecture of a first party application of a Test Base Account.
     */
    @JvmName("gsxlnogvhbiqlquk")
    public suspend fun architecture(`value`: Output<Either<String, Architecture>>) {
        this.architecture = value
    }

    /**
     * @param value The channel info of a first party application of a Test Base Account.
     */
    @JvmName("pnsuyrpyhiabfpqb")
    public suspend fun channel(`value`: Output<String>) {
        this.channel = value
    }

    /**
     * @param value Specifies how the first party applications should be inter-operated with user's application.
     */
    @JvmName("gdyqlfyscjfckpio")
    public suspend fun interopExecutionMode(`value`: Output<Either<String, InteropExecutionMode>>) {
        this.interopExecutionMode = value
    }

    /**
     * @param value The media name of a first party application of a Test Base Account.
     */
    @JvmName("emuqrrtnxcpypwpg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ring info of a first party application of a Test Base Account.
     */
    @JvmName("okqrdubbrdmbpiwu")
    public suspend fun ring(`value`: Output<String>) {
        this.ring = value
    }

    /**
     * @param value The architecture of a first party application of a Test Base Account.
     */
    @JvmName("ftykrlamyqfekrxy")
    public suspend fun architecture(`value`: Either<String, Architecture>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.architecture = mapped
    }

    /**
     * @param value The architecture of a first party application of a Test Base Account.
     */
    @JvmName("vptdkyegaknpognv")
    public fun architecture(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Architecture>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.architecture = mapped
    }

    /**
     * @param value The architecture of a first party application of a Test Base Account.
     */
    @JvmName("wnsfwegkexglnucb")
    public fun architecture(`value`: Architecture) {
        val toBeMapped = Either.ofRight<String, Architecture>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.architecture = mapped
    }

    /**
     * @param value The channel info of a first party application of a Test Base Account.
     */
    @JvmName("hokpjtqwvangivkp")
    public suspend fun channel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channel = mapped
    }

    /**
     * @param value Specifies how the first party applications should be inter-operated with user's application.
     */
    @JvmName("ebrtbaxswbkdymcj")
    public suspend fun interopExecutionMode(`value`: Either<String, InteropExecutionMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interopExecutionMode = mapped
    }

    /**
     * @param value Specifies how the first party applications should be inter-operated with user's application.
     */
    @JvmName("bfjbmejnpabnggeg")
    public fun interopExecutionMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, InteropExecutionMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.interopExecutionMode = mapped
    }

    /**
     * @param value Specifies how the first party applications should be inter-operated with user's application.
     */
    @JvmName("lgbtjhfecebaydsx")
    public fun interopExecutionMode(`value`: InteropExecutionMode) {
        val toBeMapped = Either.ofRight<String, InteropExecutionMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.interopExecutionMode = mapped
    }

    /**
     * @param value The media name of a first party application of a Test Base Account.
     */
    @JvmName("unniygbwbwodaqdv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ring info of a first party application of a Test Base Account.
     */
    @JvmName("fempkbhfrgawlwgx")
    public suspend fun ring(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ring = mapped
    }

    internal fun build(): FirstPartyAppDefinitionArgs = FirstPartyAppDefinitionArgs(
        architecture = architecture,
        channel = channel,
        interopExecutionMode = interopExecutionMode,
        name = name,
        ring = ring,
    )
}
