@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.GetCustomImagePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property customImageName The resource name of the test base custom image.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property testBaseAccountName The resource name of the Test Base Account.
 */
public data class GetCustomImagePlainArgs(
    public val customImageName: String,
    public val resourceGroupName: String,
    public val testBaseAccountName: String,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.GetCustomImagePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.GetCustomImagePlainArgs =
        com.pulumi.azurenative.testbase.inputs.GetCustomImagePlainArgs.builder()
            .customImageName(customImageName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .testBaseAccountName(testBaseAccountName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCustomImagePlainArgs].
 */
@PulumiTagMarker
public class GetCustomImagePlainArgsBuilder internal constructor() {
    private var customImageName: String? = null

    private var resourceGroupName: String? = null

    private var testBaseAccountName: String? = null

    /**
     * @param value The resource name of the test base custom image.
     */
    @JvmName("imacggpvwagkxvqc")
    public suspend fun customImageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.customImageName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ociknsrajqtxgxrr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("olnmyrkdjafhdunm")
    public suspend fun testBaseAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.testBaseAccountName = mapped
    }

    internal fun build(): GetCustomImagePlainArgs = GetCustomImagePlainArgs(
        customImageName = customImageName ?: throw PulumiNullFieldException("customImageName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        testBaseAccountName = testBaseAccountName ?: throw PulumiNullFieldException("testBaseAccountName"),
    )
}
