@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.InplaceUpgradeOSInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Specifies the baseline os and target os for in-place upgrade tests.
 * @property baselineOS Specifies the baseline os for in-place upgrade tests.
 * @property targetOS Specifies the target os for in-place upgrade tests.
 */
public data class InplaceUpgradeOSInfoArgs(
    public val baselineOS: Output<OsPropertiesArgs>? = null,
    public val targetOS: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.InplaceUpgradeOSInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.InplaceUpgradeOSInfoArgs =
        com.pulumi.azurenative.testbase.inputs.InplaceUpgradeOSInfoArgs.builder()
            .baselineOS(baselineOS?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetOS(targetOS?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InplaceUpgradeOSInfoArgs].
 */
@PulumiTagMarker
public class InplaceUpgradeOSInfoArgsBuilder internal constructor() {
    private var baselineOS: Output<OsPropertiesArgs>? = null

    private var targetOS: Output<String>? = null

    /**
     * @param value Specifies the baseline os for in-place upgrade tests.
     */
    @JvmName("ojdfmtvydcqfopls")
    public suspend fun baselineOS(`value`: Output<OsPropertiesArgs>) {
        this.baselineOS = value
    }

    /**
     * @param value Specifies the target os for in-place upgrade tests.
     */
    @JvmName("snjijwmmsgcmmgsn")
    public suspend fun targetOS(`value`: Output<String>) {
        this.targetOS = value
    }

    /**
     * @param value Specifies the baseline os for in-place upgrade tests.
     */
    @JvmName("ayaxtehgdagfapyn")
    public suspend fun baselineOS(`value`: OsPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baselineOS = mapped
    }

    /**
     * @param argument Specifies the baseline os for in-place upgrade tests.
     */
    @JvmName("ahbhejjnoqumlunj")
    public suspend fun baselineOS(argument: suspend OsPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = OsPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.baselineOS = mapped
    }

    /**
     * @param value Specifies the target os for in-place upgrade tests.
     */
    @JvmName("jfghgidjvggumjxw")
    public suspend fun targetOS(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetOS = mapped
    }

    internal fun build(): InplaceUpgradeOSInfoArgs = InplaceUpgradeOSInfoArgs(
        baselineOS = baselineOS,
        targetOS = targetOS,
    )
}
