@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.PreReleaseAccessRequestSpecArgs.builder
import com.pulumi.azurenative.testbase.kotlin.enums.Engagements
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property city
 * @property companyWebsite
 * @property countryAndRegion
 * @property email
 * @property engagements
 * @property organizationName
 * @property stateOrProvince
 * @property streetAddress
 * @property zipCode
 */
public data class PreReleaseAccessRequestSpecArgs(
    public val city: Output<String>? = null,
    public val companyWebsite: Output<String>? = null,
    public val countryAndRegion: Output<String>? = null,
    public val email: Output<String>? = null,
    public val engagements: Output<List<Either<String, Engagements>>>? = null,
    public val organizationName: Output<String>? = null,
    public val stateOrProvince: Output<String>? = null,
    public val streetAddress: Output<String>? = null,
    public val zipCode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.PreReleaseAccessRequestSpecArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.PreReleaseAccessRequestSpecArgs =
        com.pulumi.azurenative.testbase.inputs.PreReleaseAccessRequestSpecArgs.builder()
            .city(city?.applyValue({ args0 -> args0 }))
            .companyWebsite(companyWebsite?.applyValue({ args0 -> args0 }))
            .countryAndRegion(countryAndRegion?.applyValue({ args0 -> args0 }))
            .email(email?.applyValue({ args0 -> args0 }))
            .engagements(
                engagements?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .organizationName(organizationName?.applyValue({ args0 -> args0 }))
            .stateOrProvince(stateOrProvince?.applyValue({ args0 -> args0 }))
            .streetAddress(streetAddress?.applyValue({ args0 -> args0 }))
            .zipCode(zipCode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PreReleaseAccessRequestSpecArgs].
 */
@PulumiTagMarker
public class PreReleaseAccessRequestSpecArgsBuilder internal constructor() {
    private var city: Output<String>? = null

    private var companyWebsite: Output<String>? = null

    private var countryAndRegion: Output<String>? = null

    private var email: Output<String>? = null

    private var engagements: Output<List<Either<String, Engagements>>>? = null

    private var organizationName: Output<String>? = null

    private var stateOrProvince: Output<String>? = null

    private var streetAddress: Output<String>? = null

    private var zipCode: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("oyffxxekykqegkxq")
    public suspend fun city(`value`: Output<String>) {
        this.city = value
    }

    /**
     * @param value
     */
    @JvmName("joteacwlhmaykuwb")
    public suspend fun companyWebsite(`value`: Output<String>) {
        this.companyWebsite = value
    }

    /**
     * @param value
     */
    @JvmName("qbaxgoldupjdfpoc")
    public suspend fun countryAndRegion(`value`: Output<String>) {
        this.countryAndRegion = value
    }

    /**
     * @param value
     */
    @JvmName("dvaheqrhbhrwyuaf")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value
     */
    @JvmName("kiyqcwrhxtfwbaml")
    public suspend fun engagements(`value`: Output<List<Either<String, Engagements>>>) {
        this.engagements = value
    }

    @JvmName("xbglvfctqchlerav")
    public suspend fun engagements(vararg values: Output<Either<String, Engagements>>) {
        this.engagements = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ixbnibthhxyiwyqk")
    public suspend fun engagements(values: List<Output<Either<String, Engagements>>>) {
        this.engagements = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("vxjiloixydkvnpov")
    public suspend fun organizationName(`value`: Output<String>) {
        this.organizationName = value
    }

    /**
     * @param value
     */
    @JvmName("exaovfmipldxciqg")
    public suspend fun stateOrProvince(`value`: Output<String>) {
        this.stateOrProvince = value
    }

    /**
     * @param value
     */
    @JvmName("egnpnkgprwmwkavd")
    public suspend fun streetAddress(`value`: Output<String>) {
        this.streetAddress = value
    }

    /**
     * @param value
     */
    @JvmName("wcywqssubwxfdmyp")
    public suspend fun zipCode(`value`: Output<String>) {
        this.zipCode = value
    }

    /**
     * @param value
     */
    @JvmName("orhgliklrokmxrbo")
    public suspend fun city(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.city = mapped
    }

    /**
     * @param value
     */
    @JvmName("ovtdcxdwywahdbxr")
    public suspend fun companyWebsite(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.companyWebsite = mapped
    }

    /**
     * @param value
     */
    @JvmName("wgdyajoqoyrumwjo")
    public suspend fun countryAndRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.countryAndRegion = mapped
    }

    /**
     * @param value
     */
    @JvmName("mjljanecrufdhkho")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value
     */
    @JvmName("biouegrkjegbvixl")
    public suspend fun engagements(`value`: List<Either<String, Engagements>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engagements = mapped
    }

    /**
     * @param values
     */
    @JvmName("bbbvfywkhbpwxpcu")
    public suspend fun engagements(vararg values: Either<String, Engagements>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.engagements = mapped
    }

    /**
     * @param value
     */
    @JvmName("lnborpsyymtugajb")
    public suspend fun organizationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationName = mapped
    }

    /**
     * @param value
     */
    @JvmName("biijwbmhyqwodkwe")
    public suspend fun stateOrProvince(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stateOrProvince = mapped
    }

    /**
     * @param value
     */
    @JvmName("rdkxmynsunuopwcq")
    public suspend fun streetAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streetAddress = mapped
    }

    /**
     * @param value
     */
    @JvmName("vnbnekvavpjtxpkc")
    public suspend fun zipCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zipCode = mapped
    }

    internal fun build(): PreReleaseAccessRequestSpecArgs = PreReleaseAccessRequestSpecArgs(
        city = city,
        companyWebsite = companyWebsite,
        countryAndRegion = countryAndRegion,
        email = email,
        engagements = engagements,
        organizationName = organizationName,
        stateOrProvince = stateOrProvince,
        streetAddress = streetAddress,
        zipCode = zipCode,
    )
}
