@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.SubscriptionReceiverValueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The subscription role receiver value.
 * @property role The role of the notification receiver.
 * @property subscriptionId The subscription id of the notification receiver.
 * @property subscriptionName The subscription name of the notification receiver.
 */
public data class SubscriptionReceiverValueArgs(
    public val role: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
    public val subscriptionName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.SubscriptionReceiverValueArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.SubscriptionReceiverValueArgs =
        com.pulumi.azurenative.testbase.inputs.SubscriptionReceiverValueArgs.builder()
            .role(role?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .subscriptionName(subscriptionName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubscriptionReceiverValueArgs].
 */
@PulumiTagMarker
public class SubscriptionReceiverValueArgsBuilder internal constructor() {
    private var role: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    private var subscriptionName: Output<String>? = null

    /**
     * @param value The role of the notification receiver.
     */
    @JvmName("tvxvxipfbghefkcl")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value The subscription id of the notification receiver.
     */
    @JvmName("veaysukrvonjhcqr")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value The subscription name of the notification receiver.
     */
    @JvmName("abrhjqqynklncjsb")
    public suspend fun subscriptionName(`value`: Output<String>) {
        this.subscriptionName = value
    }

    /**
     * @param value The role of the notification receiver.
     */
    @JvmName("oeemmncxumofsvpf")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value The subscription id of the notification receiver.
     */
    @JvmName("iawkscsrrqtctqav")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value The subscription name of the notification receiver.
     */
    @JvmName("wiavppxtbybnuswn")
    public suspend fun subscriptionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionName = mapped
    }

    internal fun build(): SubscriptionReceiverValueArgs = SubscriptionReceiverValueArgs(
        role = role,
        subscriptionId = subscriptionId,
        subscriptionName = subscriptionName,
    )
}
