@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property applicationName
 * @property applicationVersion
 * @property billedCharges
 * @property endTimeStamp
 * @property executionRequestId
 * @property meterId
 * @property osBuild
 * @property release
 * @property sku
 * @property startTimeStamp
 * @property testType
 * @property updateType
 * @property usedBillableHours
 * @property usedFreeHours
 */
public data class BillingHubExecutionUsageDetailResponse(
    public val applicationName: String? = null,
    public val applicationVersion: String? = null,
    public val billedCharges: Double? = null,
    public val endTimeStamp: String? = null,
    public val executionRequestId: String? = null,
    public val meterId: String? = null,
    public val osBuild: String? = null,
    public val release: String? = null,
    public val sku: String? = null,
    public val startTimeStamp: String? = null,
    public val testType: String? = null,
    public val updateType: String? = null,
    public val usedBillableHours: Double? = null,
    public val usedFreeHours: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.BillingHubExecutionUsageDetailResponse): BillingHubExecutionUsageDetailResponse = BillingHubExecutionUsageDetailResponse(
            applicationName = javaType.applicationName().map({ args0 -> args0 }).orElse(null),
            applicationVersion = javaType.applicationVersion().map({ args0 -> args0 }).orElse(null),
            billedCharges = javaType.billedCharges().map({ args0 -> args0 }).orElse(null),
            endTimeStamp = javaType.endTimeStamp().map({ args0 -> args0 }).orElse(null),
            executionRequestId = javaType.executionRequestId().map({ args0 -> args0 }).orElse(null),
            meterId = javaType.meterId().map({ args0 -> args0 }).orElse(null),
            osBuild = javaType.osBuild().map({ args0 -> args0 }).orElse(null),
            release = javaType.release().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 -> args0 }).orElse(null),
            startTimeStamp = javaType.startTimeStamp().map({ args0 -> args0 }).orElse(null),
            testType = javaType.testType().map({ args0 -> args0 }).orElse(null),
            updateType = javaType.updateType().map({ args0 -> args0 }).orElse(null),
            usedBillableHours = javaType.usedBillableHours().map({ args0 -> args0 }).orElse(null),
            usedFreeHours = javaType.usedFreeHours().map({ args0 -> args0 }).orElse(null),
        )
    }
}
