@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endTimeStamp
 * @property pageIndex
 * @property pageSize
 * @property startTimeStamp
 */
public data class BillingHubGetUsageRequestResponse(
    public val endTimeStamp: String,
    public val pageIndex: Int? = null,
    public val pageSize: Int? = null,
    public val startTimeStamp: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.BillingHubGetUsageRequestResponse): BillingHubGetUsageRequestResponse = BillingHubGetUsageRequestResponse(
            endTimeStamp = javaType.endTimeStamp(),
            pageIndex = javaType.pageIndex().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            startTimeStamp = javaType.startTimeStamp(),
        )
    }
}
