@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property executionUsageDetails
 * @property osBuild
 * @property productFamily
 * @property release
 * @property releaseBuildDate
 * @property releaseBuildNumber
 * @property releaseBuildRevision
 * @property testType
 * @property totalCharges
 * @property totalUsedBillableHours
 * @property totalUsedFreeHours
 */
public data class BillingHubUsageGroupResponse(
    public val executionUsageDetails: List<BillingHubExecutionUsageDetailResponse>? = null,
    public val osBuild: String? = null,
    public val productFamily: String? = null,
    public val release: String? = null,
    public val releaseBuildDate: String? = null,
    public val releaseBuildNumber: Double? = null,
    public val releaseBuildRevision: Double? = null,
    public val testType: String? = null,
    public val totalCharges: Double? = null,
    public val totalUsedBillableHours: Double? = null,
    public val totalUsedFreeHours: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.BillingHubUsageGroupResponse): BillingHubUsageGroupResponse = BillingHubUsageGroupResponse(
            executionUsageDetails = javaType.executionUsageDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.BillingHubExecutionUsageDetailResponse.Companion.toKotlin(args0)
                })
            }),
            osBuild = javaType.osBuild().map({ args0 -> args0 }).orElse(null),
            productFamily = javaType.productFamily().map({ args0 -> args0 }).orElse(null),
            release = javaType.release().map({ args0 -> args0 }).orElse(null),
            releaseBuildDate = javaType.releaseBuildDate().map({ args0 -> args0 }).orElse(null),
            releaseBuildNumber = javaType.releaseBuildNumber().map({ args0 -> args0 }).orElse(null),
            releaseBuildRevision = javaType.releaseBuildRevision().map({ args0 -> args0 }).orElse(null),
            testType = javaType.testType().map({ args0 -> args0 }).orElse(null),
            totalCharges = javaType.totalCharges().map({ args0 -> args0 }).orElse(null),
            totalUsedBillableHours = javaType.totalUsedBillableHours().map({ args0 -> args0 }).orElse(null),
            totalUsedFreeHours = javaType.totalUsedFreeHours().map({ args0 -> args0 }).orElse(null),
        )
    }
}
