@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Metadata of the enrolled Intune app.
 * @property appId Intune app id.
 * @property appName Intune app name.
 * @property expectedInstallationPath Intune app expected installation path.
 */
public data class EnrolledIntuneAppResponse(
    public val appId: String,
    public val appName: String,
    public val expectedInstallationPath: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.EnrolledIntuneAppResponse): EnrolledIntuneAppResponse = EnrolledIntuneAppResponse(
            appId = javaType.appId(),
            appName = javaType.appName(),
            expectedInstallationPath = javaType.expectedInstallationPath(),
        )
    }
}
