@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The test base custom image resource.
 * @property creationTime The UTC timestamp when the custom image was published.
 * @property definitionName Image definition name.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property name The name of the resource
 * @property osDiskImageSizeInGB This property indicates the size of the VHD to be created.
 * @property product Product of the custom image.
 * @property provisioningState The provisioning state of the resource.
 * @property release Release of the custom image OS.
 * @property releaseVersionDate The release version date of the release of the custom image OS.
 * @property source Custom image source type.
 * @property status Status of the custom image.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property validationResults The validation result of the custom image.
 * @property versionName Image version name.
 * @property vhdFileName The file name of the associated VHD resource.
 * @property vhdId The Id of the associated VHD resource.
 */
public data class GetCustomImageResult(
    public val creationTime: String,
    public val definitionName: String,
    public val id: String,
    public val name: String,
    public val osDiskImageSizeInGB: Double,
    public val product: String,
    public val provisioningState: String,
    public val release: String,
    public val releaseVersionDate: String,
    public val source: String,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val validationResults: ImageValidationResultsResponse,
    public val versionName: String,
    public val vhdFileName: String,
    public val vhdId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.GetCustomImageResult): GetCustomImageResult = GetCustomImageResult(
            creationTime = javaType.creationTime(),
            definitionName = javaType.definitionName(),
            id = javaType.id(),
            name = javaType.name(),
            osDiskImageSizeInGB = javaType.osDiskImageSizeInGB(),
            product = javaType.product(),
            provisioningState = javaType.provisioningState(),
            release = javaType.release(),
            releaseVersionDate = javaType.releaseVersionDate(),
            source = javaType.source(),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            validationResults = javaType.validationResults().let({ args0 ->
                com.pulumi.azurenative.testbase.kotlin.outputs.ImageValidationResultsResponse.Companion.toKotlin(args0)
            }),
            versionName = javaType.versionName(),
            vhdFileName = javaType.vhdFileName(),
            vhdId = javaType.vhdId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
