@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The response of getting a download URL.
 * @property baseUrl The base URL of the storage account.
 * @property draftPackagePath The relative path of the folder hosting package files.
 * @property expirationTime Expiry date of the SAS token.
 * @property sasToken A SAS token for the storage account to access workspace.
 * @property workingPath The relative path for a temporary folder for package creation work.
 */
public data class GetDraftPackagePathResult(
    public val baseUrl: String,
    public val draftPackagePath: String,
    public val expirationTime: String,
    public val sasToken: String,
    public val workingPath: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.GetDraftPackagePathResult): GetDraftPackagePathResult = GetDraftPackagePathResult(
            baseUrl = javaType.baseUrl(),
            draftPackagePath = javaType.draftPackagePath(),
            expirationTime = javaType.expirationTime(),
            sasToken = javaType.sasToken(),
            workingPath = javaType.workingPath(),
        )
    }
}
